#############################################################################################################
# R Script to plot block alignment from deepBlockAlign.                                                     #
# Args: 'aln file' 'PNG file', 'x-axis length', 'line start', 'line end', 'Query Id', 'Subject Id', 'Score' #
#############################################################################################################

ARGV <- commandArgs(TRUE)
d <- read.table(ARGV[1], sep="\t")
plot <- paste("", ARGV[2], sep="")
pdf(plot)

xcolor <- rep("darkred", ARGV[3])
ycolor <- rep("darkblue", ARGV[3])

#color <- c("Red", "Blue", "Green")
xcolor = as.numeric(d[ARGV[4]:ARGV[5],2] == -1)
xcolor[xcolor==1] <- "darkgreen"
xcolor[xcolor==0] <- "darkred"
ycolor = as.numeric(d[ARGV[4]:ARGV[5],3] == -1)
ycolor[ycolor==1] <- "darkgreen"
ycolor[ycolor==0] <- "darkblue"

linetype <- c(1, 4)
pointer <- c(2, 4)

qprofile = d[ARGV[4]:ARGV[5],2]
sprofile = d[ARGV[4]:ARGV[5],3]

#Get maximum expression for query and subject profile
qmax = max(d[ARGV[4]:ARGV[5],2]);
smax = max(d[ARGV[4]:ARGV[5],3]);

#Get the range for the x and y axis
xrange <- range(1:ARGV[3])
#yrange <- range(0,1.2)
yrange <- range(0, (max(qmax, smax)+0.2))

#Set up the plot
plot(xrange, yrange, type="n", xlab="Coordinate", ylab="Normalized Read Count", cex.lab=1.6, cex.axis=1.6)

qprofile[qprofile==-1] <- 0
sprofile[sprofile==-1] <- 0

#Add lines
lines(d[ARGV[4]:ARGV[5],1], qprofile, type="o", lty=linetype[1], col=xcolor, pch=pointer[1])
lines(d[ARGV[4]:ARGV[5],1], sprofile, type="o", lty=linetype[2], col=ycolor, pch=pointer[2])

#Add title
plot_title <- paste("Block ", ARGV[9], " with ", ARGV[10], " (Score=", ARGV[8], ")", sep="");
title(main=plot_title, cex.main=2)

#Add a legend
legend(xrange[1], yrange[2], c(ARGV[6], ARGV[7], "gaps"), cex=0.8, col=c("darkred", "darkblue", "darkgreen"), pch=2:4, lty=1:4, bty="n")

garbage <- dev.off()
q()
