/*
 * evolutionary.h
 *
 *  Created on: 06.02.2011
 *      Author: Stefan Seemann
 */

#ifndef EVOLUTIONARY_H_
#define EVOLUTIONARY_H_

#include "petfoldlibs.h"
#include "col.h"
#include "phyl.h"


int *get_prob_tree(Aln *align_gf, double **paired_tree, double *single_tree, char *settree);
int Aln2EntryList(Aln *align, Entry **entry_list);
Entry *MyNewEntry(char *type, char *name, int len);

/* copied from Pfold:mltree.c */
typedef struct NodeInfo {
  int seqnum;               /* Sequence at this node */
  Matrix *pmatrix;          /* Matrix for up branch evolution */
  Matrix **p_top_up;         /* Probability distribution of tree above
			       top of up branch */
  Matrix **p_top_down;       /* Probability distribution of tree below
			       top of up branch */
  Matrix **p_bot_up;         /* Probability distribution of tree above
			       bottom of up branch */
  Matrix **p_bot_down;       /* Probability distribution of tree below
			       bottom of up branch */
  Grammar *grammar;
} NodeInfo;

void initphyl(PhylNode *pnode, Grammar *grammar, Align *align);
void setmat(PhylNode *pnode, Grammar *grammar);
void downcalc(PhylNode *pnode, Align *align);
void upcalc(PhylNode *pnode, Align *align);
double optimize(PhylNode *pnode, Align *align, Grammar *grammar, Phyl *phyl, double *collikelhd);


#endif /* EVOLUTIONARY_H_ */
