/* utility.c
 *
 *    Copyright (C) 2014  Nikolai Hecker
 *
 *   This program is free software: you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation, either version 3 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
#include <stdio.h>
#include <stdlib.h>
#include "constants.h"
#include "datatypes.h"
#include "math.h"
#include <limits.h>


/* --------------------- compare_ulong -------------------
 *
 * comparison function for unsigned long, needed for qsort...
 */
int
compare_ulong(const void* a, const void* b)
{
  unsigned long ula, ulb;

  ula = *(unsigned long*)a;
  ulb = *(unsigned long*)b;

  return ( ula - ulb );
}


/* --------------------- compare_double -------------------
 *
 * comparison function for double, needed for qsort...
 */
int
compare_double(const void* a, const void* b)
{
  double da, db;

  da = *(double*)a;
  db = *(double*)b;

  if( (da-db) < TINY)
    {
      return -1;
    }
  else
    {
      if( (da-db) > TINY)
	{
	  return 1;
	}
      else
	{
	  return 0;
	}
    }
}


/* --------------------- compare_twoiddbl -------------------
 *
 * comparison function for TWOIDDbl, needed for qsort...
 */
int
compare_twoiddbl(const void* a, const void* b)
{
  TWOIDDbl *twoa, *twob;

  twoa = (TWOIDDbl*)a;
  twob = (TWOIDDbl*)b;

  return ( compare_double( &(twoa->v), &(twob->v) ) );
}



/* --------------------- compare_pid_twoiddbl -------------------
 *
 * comparison function for TWOIDDbl, needed for qsort...
 */
int
compare_pid_twoiddbl(const void* a, const void* b)
{
  TWOIDDbl *twoa, *twob;

  twoa = (TWOIDDbl*)a;
  twob = (TWOIDDbl*)b;

  return ( compare_ulong( &(twoa->pid), &(twob->pid) ) );
}
