#
# R functions to plot contour from a 
# CSV matrix file
#
#    Copyright (C) 2015  Nikolai Hecker
#
#   This program is free software: you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation, either version 3 of the License, or
#   (at your option) any later version.
#
#   This program is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.
#
#   You should have received a copy of the GNU General Public License
#   along with this program.  If not, see <http://www.gnu.org/licenses/>.
# 
############################################################################
library('graphics')


########################################
# function to plot contour from matrix #
# and draw rectangle                   #
# assumed to start with 0              #
########################################
plot_matcontour_rect<- function(m, l, b, r, t, max_row=201, max_col=201, cutoff=-.Machine$double.xmax)
  {
    if(ncol(m) < max_col)
      {
        max_col <- ncol(m)
      }
    if(nrow(m) < max_row)
      {
        max_row <- nrow(m)
      }
    
    tm <- m[c(1:max_row), c(1:max_col)]

    

    for(i in c(1:nrow(tm)))
      {
        for(j in c(1:ncol(tm)))
          {                   
            if(tm[i,j] < cutoff)
              {
                tm[i,j] <- cutoff
              }
          }
      }

    xlab <- seq(0, (max_row-1), length.out=11)
    xat <- seq(1, max_row, length.out=11)

    ylab <- seq(0, (max_col-1), length.out=11)
    yat <- seq(1, max_col, length.out=11)

    par(mar=c(5,5,5,5))
    filled.contour(x = 1:max_row, y = 1:max_col, z = tm, color.palette=terrain.colors,
                   plot.axes={ axis(1, at=xat, labels=xlab, cex.axis=1.25); axis(2, at=yat, labels=ylab, cex.axis=1.25);
                               rect(l, b, r, t); grid(20, 20, col="darkblue")
                             }, xlab="5' extension [nt]", ylab="3' extension [nt]", cex.lab=1.5)
  }


########################################
# function to plot contour from matrix #
# assumed to start with 0              #
########################################
plot_matcontour <- function(m, max_row=201, max_col=201, cutoff=-.Machine$double.xmax)
  {
    if(ncol(m) < max_col)
      {
        max_col <- ncol(m)
      }
    if(nrow(m) < max_row)
      {
        max_row <- nrow(m)
      }
    
    tm <- m[c(1:max_row), c(1:max_col)]

    

    for(i in c(1:nrow(tm)))
      {
        for(j in c(1:ncol(tm)))
          {                   
            if(tm[i,j] < cutoff)
              {
                tm[i,j] <- cutoff
              }
          }
      }

    xlab <- seq(0, (max_row-1), length.out=11)
    xat <- seq(1, max_row, length.out=11)

    ylab <- seq(0, (max_col-1), length.out=11)
    yat <- seq(1, max_col, length.out=11)

    par(mar=c(5,5,5,5))
    filled.contour(x = 1:max_row, y = 1:max_col, z = tm, color.palette=terrain.colors, plot.axes={ axis(1, at=xat, labels=xlab, cex.axis=1.25); axis(2, at=yat, labels=ylab, cex.axis=1.25); grid(20, 20, col="darkblue") }, xlab="5' extension [nt]", ylab="3' extension [nt]", cex.lab=1.5)
  }


#######################################
# creates matrix from rddG data.frame #
# left will be row                    #
# right will be column                #
# should start at 0                   #
#######################################
get_rddG_matrix <- function(df)
  {
    init <- 0
    
    maxl <- max(df$l5prime)
    maxr <- max(df$l3prime)

    mddG <- matrix(0, nrow=(maxl+1), ncol=(maxr+1))

    for(i in c(1:nrow(df)))
      {
        l <- df[i,]$l5prime + 1
        r <- df[i,]$l3prime + 1

        mddG[l,r] <- df[i,]$ddG
      }

    return(mddG)    
  }


#################################
# converts ddG into probability #
#################################
convert_ddG2prob <- function(v_ddG, temp=37.0)
  {
    
    kT <- (temp+273.15)*1.98717/1000
    p <- exp(v_ddG/kT)
    
  }
