#!/usr/bin/gawk -f

#########################################################################
#  program merge_head2col / merge_head2col.awk
#
#  001019 Jan Gorodkin (gorodkin@bioinf.au.dk)
#
#  Copyright (C) 2000 Jan Gorodkin
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful, but
#  WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
#  General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
#  02111-1307, USA.
#
#########################################################################



BEGIN{
 allout=0;
 dbheadstat="NOT OK";
 eheadstat="NOT OK";
 dbhead="nothing_yet";
 ehead="nothing_yet";

 # read options
 for(a=1;a<ARGC+1;a++)
 {
   if(ARGV[a]=="-dbhead") { dbhead=ARGV[a+1]; delete ARGV[a]; delete ARGV[a+1]; }
   else if(ARGV[a]=="-ehead") { ehead=ARGV[a+1]; delete ARGV[a]; delete ARGV[a+1]; }
   else if(ARGV[a]=="-help" || ARGV[a]=="-")
   {
     print "Usage:   merge_head2col [options] <file>";
     print "Options:";
     print "-dbhead <file> The head file of the database.";
     print "-ehead <file>  The file containing header for each entry. Each entry is";
     print "               added to the corresponding data";
     print "-help (or \"-\") Show this list.";
     exit;
   }
 }

 # read dbhead file
 dbcount=1;
 getdbhead=("cat "dbhead)" 2>& 1";
 while( (getdbhead | getline tmpline) > 0 )
 { 
   n=split(tmpline,tmps," ");
   if(tmps[1]==";") dbheadline[dbcount++]=tmpline;
   dbheadstat="OK";
 }
 close(getdbhead);

 # read entry file
 getehead=("cat "ehead)" 2>& 1";
 while( (getehead | getline tmpline) > 0 )
 { 
   n=split(tmpline,tmps," ");
   if(toupper(tmps[2])=="ENTRY") { getent=1; entry=toupper(tmps[3]); }
   if(substr(tmps[2],1,10)=="**********") getent=0;
   if(getent==1) { k[entry]++; entryline[k[entry],entry]=tmpline; }
   eheadstat="OK";
 }
 close(getehead);
}


# write out db header
substr($2,1,10)=="=========="{ 
 allout=1;
 if(dbheadstat=="OK") for(i=1;i<dbcount;i++) print dbheadline[i];
}

# write out everything
allout==1{ print $0;} 

# write out header
toupper($2)=="ENTRY"&&eheadstat=="OK"{ entry=toupper($3); for(i=2;i<k[entry];i++) print entryline[i,entry]; }


END{}
################## end of file ###################


