#include "phytree.h"
#include "squid.h"
#include "structs.h"
#include "funcs.h"
#include "msa.h"
#include <stdio.h>
#include <stdlib.h>
#include <assert.h>
#include <string.h>
#include "../cmfinder/global.h"
#define MAXLINE 1000


char* ParseName(char** s, char* name)
{
  int  length;  
  char* begin = *s;  
  char* tmp;  
  //while( isalnum(**s) || **s == '_' ) (*s)++;  
  while( !isspace(**s) &&  (**s!= ':') && (**s != '(') && (**s!= ')'))(*s)++;  
  length = (*s)-begin;
  if (name == NULL)
    name = malloc(sizeof(char) * (length + 1));  

  strncpy(name, begin, length);
  name[length] = '\0';
  return name;  
}

double ParseDouble(char** s)
{
  double d= strtod(*s, s);
  if ( *s== NULL) 
    fprintf(stderr, "Not double value found!\n");  
  return d;  
}


PhyNode* ParseTree(char** ptr)
{
    
  double l, l1, l2;
  PhyNode *child, *node;  
  int    i;  
  
  while(isspace(**ptr)) (*ptr)++;    
    
    if (**ptr == '(') {    
      (*ptr)++;

      node = (PhyNode*) malloc(sizeof(PhyNode));
      memset(node, 0, sizeof(PhyNode));
      
      while(**ptr != ')' ) {	
	while(isspace(**ptr)) (*ptr)++;    
	child = ParseTree(ptr);     
	
	while(**ptr != ':') (*ptr)++;
	(*ptr)++; 
	l = ParseDouble(ptr);
	
	node->children[node->nchildren++] = child;
	strcat(node->name, child->name);
	child->parent  = node;
	child->length = l;
	
	node->size += child->size;
		
	//skip while spaces and ","
	while(**ptr != ',' && **ptr != ')') (*ptr)++; 
	if (**ptr == ',') (*ptr)++; 
      }      
      
    }    
    else{        
      node = (PhyNode*) malloc(sizeof(PhyNode));
      memset(node, 0, sizeof(PhyNode));    
      ParseName(ptr, node->name);      
      node->size = 1;      
    }    
    return node;      
}


void CalcWeight(PhyNode* node)
{
  PhyNode** stack = (PhyNode**) malloc(sizeof(PhyNode*) * node->size);
  PhyNode** leaves = (PhyNode**) malloc(sizeof(PhyNode*) * node->size);
  PhyNode** sp;
  PhyNode* curr;
  int      i, leaf_count=0;
  float    max_weight=0;
  
  stack[0] = node;
  sp = stack + 1;
  while( sp > stack) {
    sp --;
    curr = *sp;
    curr->weight = curr->length / curr->size;
    if (curr->parent) 
      curr->weight += curr->parent->weight;        
    
    for(i=0; i < curr->nchildren; i++){
      *(sp++) = curr->children[i];
    }

    if (curr->nchildren == 0){      
      leaves[leaf_count ++] = curr;      
      if (curr->weight > max_weight)
	max_weight = curr->weight;      
    }
    assert(sp <= stack + node->size);    
  }
  assert(leaf_count <= node->size);  
  for(i=0; i < leaf_count; i++) {
    leaves[i]->weight /= max_weight;    
  }    
  free(stack);
  free(leaves);  
}


void PrintTree(PhyNode* node, char* indent)
{
  int i;  
  char ind[100];  
  if (node == NULL)
    return;
  
  printf("%s %s (%1.3f %1.3f)\n", indent, node->name, node->length, node->weight);
  strcpy(ind, indent);  
  strcat(ind, "\t");
  for(i=0;i < node->nchildren; i++) {    
    PrintTree(node->children[i], ind);
  }  
}


PhyNode* ReadPhyFile(char* filename)
{
  FILE* fin;
  char  buffer[MAXLINE+1];  
  char  *str= NULL, *temp;  
  int   l = 1;  
  PhyNode* tree;  
  if ( (fin = fopen(filename, "r")) == NULL) {
    printf("Fail to open file %s", filename);    
    exit(1);    
  }
  while( fgets(buffer, MAXLINE, fin) > 0) 
    {
      l += strlen(buffer) ;
    }
  fclose(fin);
  
  if ((str = malloc(sizeof(char) * l)) == NULL){
    printf("Malloc error at ReadPhyFile \n");    
    exit(1);
  }
  memset(str, 0, sizeof(char) * l);
  
  if ( (fin = fopen(filename, "r")) == NULL) {
    printf("Fail to open file %s", filename);    
    exit(1);    
  }
  
  while( fgets(buffer, MAXLINE, fin) > 0 )
    strcat(str, buffer);      

  fclose(fin);  
    
  temp = str;  
  tree = ParseTree(&temp);  
  free(str);
  return (tree);
}


PhyNode** PhyLeaves(PhyNode* node)
{
  PhyNode** stack =  (PhyNode**) malloc(sizeof(PhyNode*) * node->size);
  PhyNode** leaves = (PhyNode**) malloc(sizeof(PhyNode*) * node->size);
  PhyNode** sp;
  PhyNode* curr;
  int      leaf_count=0;
  int      i=0;  
  stack[0] = node;
  sp = stack + 1;
  while( sp > stack) {
    sp --;
    curr = *sp;    
    for(i=0; i < curr->nchildren; i++){      
      *(sp++) = curr->children[i];
    }
    
    if ( curr->nchildren == 0) {      
      leaves[leaf_count ++] = curr;      
    }    
  }
  free(stack);  
  return leaves;  
}

void PrintNodes(PhyNode** nodes, int size)
{
  int i;  
  for(i=0; i < size; i++) 
    printf("%30s\t%d\t%f\t%f\n", nodes[i]->name,  nodes[i]->size,  nodes[i]->length, nodes[i]->weight);
    
}


void FreePhytree(PhyNode* node)
{
  int i;  
  for(i=0; i < node->nchildren; i++) {    
    FreePhytree(node->children[i]);
  } 
  free(node);    
}



PhyNode* Root(PhyNode* node)
{
  PhyNode* curr= node;
  if (!node) return NULL;  
  while(curr->parent) curr = curr->parent;
  return curr;
}



