#include "phytree.h"
#include "grammar.h"
#include "funcs.h"
#include <float.h>

#include "squid.h"		/* general sequence analysis library    */
#include "msa.h"                /* squid's multiple alignment i/o       */
#include "structs.h"		/* data structures, macros, #define's   */
#include "funcs.h"		/* external functions                   */
#include "version.h"            /* versioning info for Infernal         */
#include "prior.h"
#include "../cmfinder/global.h"

int single_model_num = 2;
int pair_model_num = 1;

static double my_log(double d)
{
  return d < exp(-10) ? -10: log(d);
}

void trim_gap_cols(MSA* msa, double gapthreshold)
{
  int i,j;
  int pos = 0;
  int gapcount=0;
  for(i=0; i < msa->alen; i++){
    gapcount=0;
    for(j=0; j < msa->nseq; j++){
      if (isgap(msa->aseq[j][i])){
	gapcount++;
      }
    }
    if (gapcount <= (int)( gapthreshold * msa->nseq) || msa->ss_cons[i]!='.'){
      if (pos != i){
	for(j=0; j < msa->nseq; j++){
	  msa->aseq[j][pos] = msa->aseq[j][i];
	  if (msa->ss && msa->ss[j]){
	    msa->ss[j][pos] = msa->ss[j][i];
	  }
	}
	if (msa->rf){
	  msa->rf[pos] = msa->rf[i];	
	}
	if (msa->ss_cons){
	  msa->ss_cons[pos] = msa->ss_cons[i];
	}
      }
      pos++;
    }
  }
  if (pos != i){
    for(j=0; j < msa->nseq; j++){
      msa->aseq[j][pos] = '\0';
      if (msa->ss && msa->ss[j]){
	msa->ss[j][pos] = '\0';
      }
    }
    if (msa->rf) msa->rf[pos] = '\0';
    if (msa->ss_cons) msa->ss_cons[pos] = '\0';
  }
  msa->alen = pos;
}



int main(int argc, char* argv[])
{

  char* ali_files = argv[1];
  char* grammar_file = argv[2];
  int   format =  MSAFILE_STOCKHOLM;
  MSAFILE     *afp = NULL;        /* file handle of initial alignment */
  MSA  *msa;
  int** cols;
  int   i,j,k;
  Grammar* g;
  char parse[5000],buffer[5000];
  int   max_len = 5000;
  g = read_grammar(grammar_file);
  int*  transition_count = (int*)MallocOrDie(sizeof(int) * g->ntransitions);
  memset(transition_count, 0, sizeof(int) * g->ntransitions);
  int*  state_count = (int*)MallocOrDie(sizeof(int) * g->nstates);
  memset(state_count, 0, sizeof(int) * g->nstates);
  
  single_model_num = 2;
  pair_model_num = 1;

  for(k=0; k < single_model_num; k++){
    single_emission[k]= (double*)MallocOrDie(sizeof(double)*max_len);  
  }
  for(k=0; k < pair_model_num; k++){
    pair_emission[k]= (double**)MallocOrDie(sizeof(double)*max_len);
    for(i=0; i < max_len; i++){
      pair_emission[k][i] = (double*)MallocOrDie(sizeof(double) * max_len);
    }
  }    
  
  FILE* file_list;
  if (!(file_list = fopen(ali_files, "r"))) Die("");
  
  while(fgets(buffer, MAXLINE, file_list)){    
    char filename[MAXLINE];
    sscanf(buffer, "%s", filename);
    if ((afp = MSAFileOpen(filename, format, NULL)) == NULL)
      Die("Alignment file %s could not be opened for reading",filename);
    if ((msa = MSAFileRead(afp)) != NULL){
      MSAFileClose(afp);
    }
    else{
      Die("Error reading Alignment file %s", filename);
    }    
    trim_gap_cols(msa, 0.7);
    int* pt= GetPairtable(msa->ss_cons);
    for(i=0; i < msa->alen; i++){      
      for(k=0; k < single_model_num; k++){
	if(pt[i] >= 0) {	  
	  single_emission[k][i] = -INF;
	}
	else{
	  single_emission[k][i] = 0;
	}
      }
      for(j=0; j < msa->alen; j++){	
	if (j > i && j == pt[i]){
	  for(k=0; k < pair_model_num;k++)
	    pair_emission[k][i][j] = 0;
	}
	else{
	  for(k=0; k < pair_model_num;k++)
	    pair_emission[k][i][j] = -INF;
	}
      }
    }
    free(pt);
    printf("scan file %s\t", filename);
    Cube_table* cyk_table = init_Cube_table(0, msa->alen, g->nstates, 1);  
    double cyk_return=cyk(0, msa->alen-1, g, cyk_table);  
    printf("cyk_return %f\n", cyk_return);
    cyk_traceback(0, msa->alen-1, g, cyk_table, transition_count, parse);     
    printf("%s\n", parse);
    free_Cube_table(cyk_table);
  }
  
  
  for(i=0; i < g->ntransitions; i++){
    state_count[g->transitions[i].state] += transition_count[i];
  }

  for(i=0; i < g->ntransitions; i++){
    write_transition(&(g->transitions[i]), g);
    printf("\t%f\n", ((double)transition_count[i])/state_count[g->transitions[i].state]);
  }

  free_grammar(g);
  free(transition_count);
  MSAFree(msa); 
}



      
