#include "phytree.h"
#include "grammar.h"
#include "funcs.h"
#include <float.h>
#include "/home/users/elfar/software/CMfinder_03/gsl/include/gsl/gsl_errno.h"
#include "/home/users/elfar/software/CMfinder_03/gsl/include/gsl/gsl_math.h"
#include "numerical_opt.h"


#include "squid.h"		/* general sequence analysis library    */
#include "msa.h"                /* squid's multiple alignment i/o       */
#include "structs.h"		/* data structures, macros, #define's   */
#include "funcs.h"		/* external functions                   */
#include "version.h"            /* versioning info for Infernal         */
#include "prior.h"
#include "../cmfinder/global.h"
#include <stdio.h>
#include <stdlib.h>

#define OUTBOUND -1


extern int logscale;

EvoModel* mod;
int   pair_alphabet_size;

int   pairs[]={0*4 + 3, 1*4 + 2, 2*4 + 1, 2*4 + 3, 3*4 + 0, 3*4 + 2};

int pair_id(int id)
{
  int i;
  for(i=0; i < 6; i++){
    if (id == pairs[i]) return i;
  }
  return -1;
}


int map_pair_freq_param[4][4]={{0, 1, 2, 3},
                               {4, 5, 6, 7},
                               {8, 9, 10,11},
                               {12,13,14,15}};


int map_pair_sub_param[6][6]={{-1,  0, 1,  3,  6,10},
			      { 0, -1, 2,  4,  7,11},
			      { 1,  2,-1,  5,  8,12},
			      { 3,  4, 5, -1,  9,13},
			      { 6,  7, 8,  9, -1,14},
			      { 10,11,12, 13, 14,-1}};


#define PAIR_PAM_NUM 33
#define PAIR_FREQ_PAM_NUM 16



double init_pair_params[PAIR_PAM_NUM]={0.00168548, 0.00399812, 0.0014503, 0.158631,
				       0.00407651, 0.00168548, 0.229853,  0.00207745,
				       0.00243023, 0.24608,    0.00211665,0.0495061,
				       0.235379,   0.00219505, 0.0549545, 0.00388053,
				       7316.17,    0.358733,
				       0.000342538,
				       213.344, 0.000271525, 
				       3613.26, 0.00484582, 2644.86,
				       0.000750792,145.611,0.000121402,0.00553353,
				       0.021412, 3332.72, 0.00146057, 0.162062, 3322.05};

               
/* first 9 freq parameters (AU = UA). substitution: 15 cannonical basepair, 2 cannonical to non canonical
   (1/2 mutations), 1 noncanonical to noncanonical*/
int unpack_parameter_Evofold(const gsl_vector* params)
{
  int i,j;
  int k=0;
  double tot_freq=0;
  double subs, non_subs;
  for(i=0; i < params->size;i++){
    if (gsl_vector_get(params, k) < 0) return OUTBOUND;
  }
  for(i=0; i < Alphabet_size; i++) 
    for(j=0; j < Alphabet_size; j++){
      gsl_vector_set(mod->freq,i * Alphabet_size + j, gsl_vector_get(params,map_pair_freq_param[i][j]));	  
      tot_freq += gsl_vector_get(mod->freq,i * Alphabet_size + j);
    }

  gsl_vector_scale(mod->freq, 1/tot_freq);  
  k += PAIR_FREQ_PAM_NUM;
  subs = gsl_vector_get(params, k++);
  non_subs = gsl_vector_get(params,k++);
  
  for(i=0; i < pair_alphabet_size; i++){
    double tot=0;
    for(j=0; j < pair_alphabet_size; j++){
      if (i== j) continue;
      int l1,l2,p;
      l1 = pair_id(i);
      l2 = pair_id(j);
      if (l1>= 0 && l2 >=0){
	p = map_pair_sub_param[l1][l2];
	gsl_matrix_set(mod->rm, i, j, gsl_vector_get(params,k+p) * gsl_vector_get(mod->freq,j));
      }
      else{
	if (l1 >=0 || l2 >= 0){
	  double v =  gsl_vector_get(mod->freq,j) * subs;
	  gsl_matrix_set(mod->rm, i, j, v);	  
	}
	else{
	  double v =  gsl_vector_get(mod->freq,j) * non_subs;
	  gsl_matrix_set(mod->rm, i, j, v);	  
	}
      }
      tot += gsl_matrix_get(mod->rm, i, j);
    }
    gsl_matrix_set(mod->rm, i, i, -tot);
  }
  EvoModel_init(mod);
  return 1;
}


int main(int argc, char* argv[])
{
  char* init_model_file= argv[1];
  logscale = 0;
  pair_alphabet_size = Alphabet_size * Alphabet_size;
  mod = EvoModel_alloc(pair_alphabet_size);  
  unpack_parameter_Evofold(vector_init(init_pair_params, PAIR_PAM_NUM));
  EvoModel* tmp[1];
  tmp[0]=mod;
  EvoModel_write(stdout, "%.5f ", tmp, 1);
}



      
