#!/usr/bin/perl -w

use File::Copy;
use Cwd;

$rank_file = shift @ARGV;
$out_motif_dir = ".";
if (scalar @ARGV > 0){    
    $out_motif_dir = shift @ARGV;
}

if (! -e $out_motif_dir){
    mkdir("$out_motif_dir");
}

$threshold1 = 3;
$threshold2 = 5;

print STDERR "Read rank_file\n";
open IN, $rank_file or die "Can't open $rank_file";
$is_header=1;
%motif_features=();
%header=();
while(<IN>){    
   s/\s+$//g;    
   next if /^\s*$/;
   @fields=split /,/;
   if ($is_header){
       for($i=0; $i <= $#fields;$i++){
	   $header{$fields[$i]} = $i;
       }
       $is_header=0;
   }
   else{
       $motif = $fields[$header{"motif"}];    
       next if (! -e "$motif");
       my %features =();
       $bad_line=0;
       foreach $f (keys %header){
	   if ($header{$f} > $#fields){
	       $bad_line=1;
	       last;
	   }
	   else{
	       $features{$f} = $fields[$header{$f}];	   
	   }
       }
       next if($bad_line);
       next if ($features{"Seq_id"} > 0.95 && $features{"Weight"}<= 4);       
       $motif_features{$motif}=\%features;
   }
}

close IN;

@all_motifs = reverse sort {$motif_features{$a}->{"Score"} <=> $motif_features{$b}->{"Score"}} keys %motif_features;
%id_motifs=();
foreach $f (@all_motifs){
    $f=~ /^(\S+)\.motif/;
        $id = $1;
    if (exists $id_motifs{$id}){
	$temp = $id_motifs{$id};
	push @$temp, $f;
    }
    else{
	$id_motifs{$id} = [$f];
    }
}

%processed=();
foreach $motif (@all_motifs){    
    $motif =~ /^(\S+)\.motif/;
    $id = $1;
    next if (exists $processed{$id});
    if (!exists $id_motifs{$id}){
	die "$_ \n Can't find motifs for $id ";
    }       
    $processed{$id}=1;
    $motifs=$id_motifs{$id};
    @selected = ();
    foreach $n (@$motifs){
	last if ($motif_features{$n}->{"Score"} < $threshold1 || scalar @selected >= 4);
	last if ($motif_features{$n}->{"Score"} < $threshold2 && scalar @selected > 0);
	next if ($motif_features{$n}->{"Weight"} < 3);
	$redundant=0;
	foreach $s (@selected){
	    $structure_diff = `diff_motif $n $s`;
	    %diff = ($structure_diff=~/(\S+)=(\S+)/g);	    
	    if( $diff{"nolap_seq1"} < 0.3 * $diff{"olap_seq"} &&
		$diff{"olap_len"} * 0.5 >  $diff{"nolap_len1"}){
		if ($diff{"FP"}+ $diff{"FM"} < 0.7 * $diff{"TP"}){
		    $redundant=1;
		    last;
		}
		if ($motif_features{$n}->{"Score"}  < 0.7 * $motif_features{$s}->{"Score"}){
		    $redundant = 1;
		    last;
		}
	    }
	}
	next if ($redundant);
	push @selected, $n;
    }
    
    for($i=0; $i <= $#selected; $i++){
	@vals = ();
	$motif = $selected[$i];
	if ($motif=~ /\/([^\/]+)/){
	    $motif=$1;
	}
	$motif=~ s/\.motif\.(\S+)/\.motif\.$i/;
	$motif= "$out_motif_dir/$motif";
	$orig_cm = $selected[$i];
	$orig_cm =~ s/motif/cm/;
	$new_cm = $motif;
	$new_cm =~ s/motif/cm/;
	
	foreach $h (sort {$header{$a} <=> $header{$b}} keys %header){
	    push @vals, $motif_features{$selected[$i]}->{$h};
	}

	print (join ",", @vals);
	print "\n";

	copy("$selected[$i]", $motif);
	copy("$orig_cm", "$new_cm");	
    }
}
    

