#ifndef _GRAMMAR_H
#define _GRAMMAR_H

#include "cmfinder/global.h"
#include "phytree.h"

typedef struct 
{
  int    state;
  int    id;
  int    children[2]; //Cholesky norm: no more 2 states on the right hand side. 
  double prob;
  double logprob;
  int    emittype;
  int    emitprob;
  int    nbranch;
}
Transition;

typedef struct 
{
  int         nstates;
  char**      stateId;
  int         start;
  int         end;
  Transition  transitions[100];  //maximum 100 transitions
  int         ntransitions;
  int*        num_in;
  int*        num_out;
  int**       in;
  int**       out;
}
Grammar;

//designed only for DP diag table.
typedef struct
{
  int start;
  int length;
  int nstates;
  int size;
  double* storage;
  Transition** trace;
  int*    bifur;
}
Cube_table;

#define LEFT  0
#define RIGHT 1
#define PAIR  2

double* single_emission[10];
double** pair_emission[10];

Grammar*  read_grammar(char* filename);

void free_grammar(Grammar* g);

Cube_table* init_Cube_table(int start, int length, int nstates, int inc_trace);

void free_Cube_table(Cube_table* t);

void Cube_table_set_all(Cube_table* table, double value);

double Cube_table_get(Cube_table* table, int i, int j, int v);

int cyk(int start, int end, Grammar *g, Cube_table* cyk_table);

void cyk_traceback(int start, int end, Grammar *g, 
		    Cube_table* cyk_table, int* count, char* mark);

int inside(int start, int end, Grammar *g, 
	   Cube_table* inside_table,
	   Cube_table* trans_inside_table);

void outside(int start, int end, Grammar *g, 
	     Cube_table* outside_table,
	     Cube_table* inside_table);

void posterior(int start, int end, Grammar *g,
               Cube_table* outside_table,
               Cube_table* inside_table,
               Cube_table* trans_inside_table,
               Cube_table* transition_posterior,
               Cube_table* state_posterior,
               double* single_posterior[],
               double** pair_posterior[]);

#endif


