/************************************************************
 *    This copyrighted source code is freely distributed 
 *    under the terms of the GNU General Public License. See
 *    the files COPYRIGHT and LICENSE for details.
 ************************************************************/

/* hmmband.h 
 * Eric Nawrocki 
 * 12.16.05 
 * (many functions older than 12.16.05) 
 *
 * Functions to support either CM Plan 9 (CP9) HMMs for band
 * calculation. Includes functions for calc'ing posteriors.
 * 
 * Note: Initially, plan 7 (P7) versions of most of these functions
 * were implemented, but abandoned once it was clear CP9s were 
 * more appropriate for CMs. To see the original P7 funcs, see
 * the end of the hmmband.c file.
 */

#include "config.h"
#include "squid.h"		/* general sequence analysis library    */
#include "msa.h"                /* squid's multiple alignment i/o       */
#include "stopwatch.h"          /* squid's process timing module        */
#include "structs.h"		/* data structures, macros, #define's   */
#include "sre_stack.h"
#include "cplan9.h"

extern CP9Bands_t * AllocCP9Bands(CM_t *cm, struct cplan9_s *hmm);
extern void FreeCP9Bands(CP9Bands_t *cp9bands);

extern double dbl_Score2Prob(int sc, float null);

/* Functions for getting posterior probabilities from CP9 HMMs 
 * based on Ian Holmes' hmmer/src/postprob.c functions 
 * P7Forward() is in HMMER's core_algorithms.c 
 * and P7Backward() is in HMMER's postprob.c*/
extern float CP9Forward(char *dsq, int i0, int j0, struct cplan9_s *hmm, 
			struct cp9_dpmatrix_s **ret_mx);
extern float CP9Viterbi(char *dsq, int i0, int j0, struct cplan9_s *hmm, struct cp9_dpmatrix_s *mx);
extern float CP9Backward(char *dsq, int i0, int j0, struct cplan9_s *hmm, struct cp9_dpmatrix_s **ret_mx);
extern void  CP9FullPosterior(char *dsq, int i0, int j0,
			      struct cplan9_s *hmm,
			      struct cp9_dpmatrix_s *fmx,
			      struct cp9_dpmatrix_s *bmx,
			      struct cp9_dpmatrix_s *mx);
extern void CP9_ifill_post_sums(struct cp9_dpmatrix_s *post, int i0, int j0, int M,
				int *isum_pn_m, int *isum_pn_i, int *isum_pn_d);

/* Functions to determine HMM bands */
extern void CP9_hmm_band_bounds(int **post, int i0, int j0, int M, int *isum_pn, int *pn_min, int *pn_max, double p_thresh, 
				int state_type, int use_sums, int debug_level);

/* Functions to go from HMM bands to i and j bands on a CM */
extern void hmm2ij_bands(CM_t *cm, CP9Map_t *cp9map, int i0, int j0, int *pn_min_m, 
			 int *pn_max_m, int *pn_min_i, int *pn_max_i, int *pn_min_d, 
			 int *pn_max_d, int *imin, int *imax, int *jmin, int *jmax, 
			 int debug_level);

/* Helper functions for *_hmm2ij_bands() */
extern void hmm2ij_prestate_step0_initialize(int n, int *nss_max_imin, int *nss_min_jmax, int i0, int j0);
extern void hmm2ij_prestate_step1_set_node_inserts(int n, int *nis_imin, int *nis_imax, 
						   int *nis_jmin, int *nis_jmax,
						   int *nss_imin, int *nss_imax, 
						   int *nss_jmin, int *nss_jmax,
						   int *pn_min_i, int *pn_max_i, 
						   CP9Map_t *cp9map);
extern void hmm2ij_prestate_step2_determine_safe(int n, 	
						 int nss_max_imin_np1, int nss_min_jmax_np1,
						 int nis_imin_n, 
						 int nis_jmax_n,
						 int *safe_imax, int *safe_jmin);
extern void hmm2ij_prestate_step3_preset_node_splits(int n, int *nis_imin, int *nis_imax, 
						     int *nis_jmin, int *nis_jmax,
						     int *nss_imin, int *nss_imax, 
						     int *nss_jmin, int *nss_jmax,
						     int *pn_min_m, int *pn_max_m, 
						     int *pn_min_d, int *pn_max_d, 
						     CP9Map_t *cp9map);
extern void hmm2ij_split_state_step1_set_state_bands(int v, int n, 
						     int tmp_imin, int tmp_imax, 
						     int tmp_jmin, int tmp_jmax,
						     int *imin, int *imax, int *jmin, int *jmax,
						     int *nss_imin, int *nss_imax,
						     int *nss_jmin, int *nss_jmax);
extern void hmm2ij_insert_state_step1_set_state_bands(int v, 
						      int tmp_imin, int tmp_imax, 
						      int tmp_jmin, int tmp_jmax,
						      int *imin, int *imax, int *jmin, int *jmax);
extern void hmm2ij_state_step2_enforce_safe_trans(CM_t *cm, int v, int n, int *imax, int *jmin,
						  int *nss_imax, int *nss_jmin, 
						  int safe_imax, int safe_jmin);
extern void hmm2ij_state_step3_enforce_state_delta(CM_t *cm, int v, int *jmin, int *jmax);
extern void hmm2ij_state_step4_update_safe_holders(int v, int n, int imin_v, int jmax_v, int *nss_max_imin, 
						   int *nss_min_jmax);
extern void hmm2ij_state_step5_non_emitter_d0_hack(int v, int imax_v, int *jmin);

/* Debugging print functions */
extern void print_hmm_bands(FILE *ofp, int L, int M, int *pn_min_m, int *pn_max_m,
			    int *pn_min_i, int *pn_max_i, int *pn_min_d,
			    int *pn_max_d, double hmm_bandp, int debug_level);
extern void ij_banded_trace_info_dump(CM_t *cm, Parsetree_t *tr, int *imin, int *imax, 
				      int *jmin, int *jmax, int debug_level);
extern void ijd_banded_trace_info_dump(CM_t *cm, Parsetree_t *tr, int *imin, int *imax, 
				      int *jmin, int *jmax, int **hdmin, int **hdmax, 
				      int debug_level);
extern void debug_check_CP9_FB(struct cp9_dpmatrix_s *fmx, 
			       struct cp9_dpmatrix_s *bmx, 
			       struct cplan9_s *hmm, float sc, int i0, int j0,
			       char *dsq);

/* Other misc. functions */
extern void relax_root_bands(int *imin, int *imax, int *jmin, int *jmax);
