/** @file RNAsnp_cmdl.h
 *  @brief The header file for the command line option parser
 *  generated by GNU Gengetopt version 2.22.6
 *  http://www.gnu.org/software/gengetopt.
 *  DO NOT modify this file, since it can be overwritten
 *  @author GNU Gengetopt by Lorenzo Bettini */

#ifndef RNASNP_CMDL_H
#define RNASNP_CMDL_H

/* If we use autoconf.  */
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <stdio.h> /* for FILE */

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

#ifndef RNASNP_CMDLINE_PARSER_PACKAGE
/** @brief the program name (used for printing errors) */
#define RNASNP_CMDLINE_PARSER_PACKAGE "RNAsnp"
#endif

#ifndef RNASNP_CMDLINE_PARSER_PACKAGE_NAME
/** @brief the complete program name (used for help and version) */
#define RNASNP_CMDLINE_PARSER_PACKAGE_NAME "RNAsnp"
#endif

#ifndef RNASNP_CMDLINE_PARSER_VERSION
/** @brief the program version */
#define RNASNP_CMDLINE_PARSER_VERSION "1.2"
#endif

/** @brief Where the command line options are stored */
struct RNAsnp_args_info
{
  const char *help_help; /**< @brief Print help and exit help description.  */
  const char *detailed_help_help; /**< @brief Print help, including all details and hidden options, and exit help description.  */
  const char *full_help_help; /**< @brief Print help, including hidden options, and exit help description.  */
  const char *version_help; /**< @brief Print version and exit help description.  */
  char * seq_arg;	/**< @brief File containing the input sequence
.  */
  char * seq_orig;	/**< @brief File containing the input sequence
 original value given at command line.  */
  const char *seq_help; /**< @brief File containing the input sequence
 help description.  */
  char * snp_arg;	/**< @brief File containing the list of SNP
.  */
  char * snp_orig;	/**< @brief File containing the list of SNP
 original value given at command line.  */
  const char *snp_help; /**< @brief File containing the list of SNP
 help description.  */
  int mode_arg;	/**< @brief Select the mode of operation (default=`1')
  
  1 - perform global folding by using RNAfold and compute the difference in base pair probabilities for all sequence intervals
    
  2 - perform local folding by using RNAplfold and compute the difference in base pair probabilities for all sequence intervals of fixed length
  
  3 - screen putative structure-disruptive SNPs in an RNA sequence
.  */
  char * mode_orig;	/**< @brief Select the mode of operation (default=`1')
  
  1 - perform global folding by using RNAfold and compute the difference in base pair probabilities for all sequence intervals
    
  2 - perform local folding by using RNAplfold and compute the difference in base pair probabilities for all sequence intervals of fixed length
  
  3 - screen putative structure-disruptive SNPs in an RNA sequence
 original value given at command line.  */
  const char *mode_help; /**< @brief Select the mode of operation (default=`1')
  
  1 - perform global folding by using RNAfold and compute the difference in base pair probabilities for all sequence intervals
    
  2 - perform local folding by using RNAplfold and compute the difference in base pair probabilities for all sequence intervals of fixed length
  
  3 - screen putative structure-disruptive SNPs in an RNA sequence
 help description.  */
  int winsizeFold_arg;	/**< @brief length of flanking sequence on either side of SNP to fold (default='200').  */
  char * winsizeFold_orig;	/**< @brief length of flanking sequence on either side of SNP to fold original value given at command line.  */
  const char *winsizeFold_help; /**< @brief length of flanking sequence on either side of SNP to fold help description.  */
  float cutoff_arg;	/**< @brief minimum cut-off for the base pair probabilities. This parameter is applicable to both Mode 1 and 2 (default='0.01').  */
  char * cutoff_orig;	/**< @brief minimum cut-off for the base pair probabilities. This parameter is applicable to both Mode 1 and 2 original value given at command line.  */
  const char *cutoff_help; /**< @brief minimum cut-off for the base pair probabilities. This parameter is applicable to both Mode 1 and 2 help description.  */
  int minLen_arg;	/**< @brief minimum length of the sequence interval (default='50').  */
  char * minLen_orig;	/**< @brief minimum length of the sequence interval original value given at command line.  */
  const char *minLen_help; /**< @brief minimum length of the sequence interval help description.  */
  int winsize_arg;	/**< @brief Average the pair probabilities over windows of given size (default='200').  */
  char * winsize_orig;	/**< @brief Average the pair probabilities over windows of given size original value given at command line.  */
  const char *winsize_help; /**< @brief Average the pair probabilities over windows of given size help description.  */
  int span_arg;	/**< @brief Set the maximum allowed separation of a base pair to span. i.e. no pairs (i,j) with j-i > L will be allowed. (default='120').  */
  char * span_orig;	/**< @brief Set the maximum allowed separation of a base pair to span. i.e. no pairs (i,j) with j-i > L will be allowed. original value given at command line.  */
  const char *span_help; /**< @brief Set the maximum allowed separation of a base pair to span. i.e. no pairs (i,j) with j-i > L will be allowed. help description.  */
  int regionX_arg;	/**< @brief Length of the local structural element that we expect to have an effect (default='20').  */
  char * regionX_orig;	/**< @brief Length of the local structural element that we expect to have an effect original value given at command line.  */
  const char *regionX_help; /**< @brief Length of the local structural element that we expect to have an effect help description.  */
  int regionY_arg;	/**< @brief Length of the interval over which the local structural changes are evaluated, i.e., the maximal span of a base pair (default='120').  */
  char * regionY_orig;	/**< @brief Length of the interval over which the local structural changes are evaluated, i.e., the maximal span of a base pair original value given at command line.  */
  const char *regionY_help; /**< @brief Length of the interval over which the local structural changes are evaluated, i.e., the maximal span of a base pair help description.  */
  float pvalue1_arg;	/**< @brief p-value threshold to filter SNPs that are predicted using Mode 2 (default='0.4').  */
  char * pvalue1_orig;	/**< @brief p-value threshold to filter SNPs that are predicted using Mode 2 original value given at command line.  */
  const char *pvalue1_help; /**< @brief p-value threshold to filter SNPs that are predicted using Mode 2 help description.  */
  float pvalue2_arg;	/**< @brief p-value threshold to filter SNPs that are predicted using Mode 1 (default='0.1').  */
  char * pvalue2_orig;	/**< @brief p-value threshold to filter SNPs that are predicted using Mode 1 original value given at command line.  */
  const char *pvalue2_help; /**< @brief p-value threshold to filter SNPs that are predicted using Mode 1 help description.  */
  int winsizeExt_arg;	/**< @brief size of the flanking region on either side of SNP that includes the local window returned by Mode 2. This subsequence is then passed to Mode 1 for re-computation (default='200').  */
  char * winsizeExt_orig;	/**< @brief size of the flanking region on either side of SNP that includes the local window returned by Mode 2. This subsequence is then passed to Mode 1 for re-computation original value given at command line.  */
  const char *winsizeExt_help; /**< @brief size of the flanking region on either side of SNP that includes the local window returned by Mode 2. This subsequence is then passed to Mode 1 for re-computation help description.  */
  int edist_arg;	/**< @brief compute ensemble Euclidean distance between the distribution of structures between two sequences (default='0').  */
  char * edist_orig;	/**< @brief compute ensemble Euclidean distance between the distribution of structures between two sequences original value given at command line.  */
  const char *edist_help; /**< @brief compute ensemble Euclidean distance between the distribution of structures between two sequences help description.  */
  double boltzmannPreFactor_arg;	/**< @brief Multiply the Boltzmann factor with a prefactor alpha (default='1').  */
  char * boltzmannPreFactor_orig;	/**< @brief Multiply the Boltzmann factor with a prefactor alpha original value given at command line.  */
  const char *boltzmannPreFactor_help; /**< @brief Multiply the Boltzmann factor with a prefactor alpha help description.  */
  
  unsigned int help_given ;	/**< @brief Whether help was given.  */
  unsigned int detailed_help_given ;	/**< @brief Whether detailed-help was given.  */
  unsigned int full_help_given ;	/**< @brief Whether full-help was given.  */
  unsigned int version_given ;	/**< @brief Whether version was given.  */
  unsigned int seq_given ;	/**< @brief Whether seq was given.  */
  unsigned int snp_given ;	/**< @brief Whether snp was given.  */
  unsigned int mode_given ;	/**< @brief Whether mode was given.  */
  unsigned int winsizeFold_given ;	/**< @brief Whether winsizeFold was given.  */
  unsigned int cutoff_given ;	/**< @brief Whether cutoff was given.  */
  unsigned int minLen_given ;	/**< @brief Whether minLen was given.  */
  unsigned int winsize_given ;	/**< @brief Whether winsize was given.  */
  unsigned int span_given ;	/**< @brief Whether span was given.  */
  unsigned int regionX_given ;	/**< @brief Whether regionX was given.  */
  unsigned int regionY_given ;	/**< @brief Whether regionY was given.  */
  unsigned int pvalue1_given ;	/**< @brief Whether pvalue1 was given.  */
  unsigned int pvalue2_given ;	/**< @brief Whether pvalue2 was given.  */
  unsigned int winsizeExt_given ;	/**< @brief Whether winsizeExt was given.  */
  unsigned int edist_given ;	/**< @brief Whether edist was given.  */
  unsigned int boltzmannPreFactor_given ;	/**< @brief Whether boltzmannPreFactor was given.  */

} ;

/** @brief The additional parameters to pass to parser functions */
struct RNAsnp_cmdline_parser_params
{
  int override; /**< @brief whether to override possibly already present options (default 0) */
  int initialize; /**< @brief whether to initialize the option structure RNAsnp_args_info (default 1) */
  int check_required; /**< @brief whether to check that all required options were provided (default 1) */
  int check_ambiguity; /**< @brief whether to check for options already specified in the option structure RNAsnp_args_info (default 0) */
  int print_errors; /**< @brief whether getopt_long should print an error message for a bad option (default 1) */
} ;

/** @brief the purpose string of the program */
extern const char *RNAsnp_args_info_purpose;
/** @brief the usage string of the program */
extern const char *RNAsnp_args_info_usage;
/** @brief the description string of the program */
extern const char *RNAsnp_args_info_description;
/** @brief all the lines making the help output */
extern const char *RNAsnp_args_info_help[];
/** @brief all the lines making the full help output (including hidden options) */
extern const char *RNAsnp_args_info_full_help[];
/** @brief all the lines making the detailed help output (including hidden options and details) */
extern const char *RNAsnp_args_info_detailed_help[];

/**
 * The command line parser
 * @param argc the number of command line options
 * @param argv the command line options
 * @param args_info the structure where option information will be stored
 * @return 0 if everything went fine, NON 0 if an error took place
 */
int RNAsnp_cmdline_parser (int argc, char **argv,
  struct RNAsnp_args_info *args_info);

/**
 * The command line parser (version with additional parameters - deprecated)
 * @param argc the number of command line options
 * @param argv the command line options
 * @param args_info the structure where option information will be stored
 * @param override whether to override possibly already present options
 * @param initialize whether to initialize the option structure my_args_info
 * @param check_required whether to check that all required options were provided
 * @return 0 if everything went fine, NON 0 if an error took place
 * @deprecated use RNAsnp_cmdline_parser_ext() instead
 */
int RNAsnp_cmdline_parser2 (int argc, char **argv,
  struct RNAsnp_args_info *args_info,
  int override, int initialize, int check_required);

/**
 * The command line parser (version with additional parameters)
 * @param argc the number of command line options
 * @param argv the command line options
 * @param args_info the structure where option information will be stored
 * @param params additional parameters for the parser
 * @return 0 if everything went fine, NON 0 if an error took place
 */
int RNAsnp_cmdline_parser_ext (int argc, char **argv,
  struct RNAsnp_args_info *args_info,
  struct RNAsnp_cmdline_parser_params *params);

/**
 * Save the contents of the option struct into an already open FILE stream.
 * @param outfile the stream where to dump options
 * @param args_info the option struct to dump
 * @return 0 if everything went fine, NON 0 if an error took place
 */
int RNAsnp_cmdline_parser_dump(FILE *outfile,
  struct RNAsnp_args_info *args_info);

/**
 * Save the contents of the option struct into a (text) file.
 * This file can be read by the config file parser (if generated by gengetopt)
 * @param filename the file where to save
 * @param args_info the option struct to save
 * @return 0 if everything went fine, NON 0 if an error took place
 */
int RNAsnp_cmdline_parser_file_save(const char *filename,
  struct RNAsnp_args_info *args_info);

/**
 * Print the help
 */
void RNAsnp_cmdline_parser_print_help(void);
/**
 * Print the full help (including hidden options)
 */
void RNAsnp_cmdline_parser_print_full_help(void);
/**
 * Print the detailed help (including hidden options and details)
 */
void RNAsnp_cmdline_parser_print_detailed_help(void);
/**
 * Print the version
 */
void RNAsnp_cmdline_parser_print_version(void);

/**
 * Initializes all the fields a RNAsnp_cmdline_parser_params structure 
 * to their default values
 * @param params the structure to initialize
 */
void RNAsnp_cmdline_parser_params_init(struct RNAsnp_cmdline_parser_params *params);

/**
 * Allocates dynamically a RNAsnp_cmdline_parser_params structure and initializes
 * all its fields to their default values
 * @return the created and initialized RNAsnp_cmdline_parser_params structure
 */
struct RNAsnp_cmdline_parser_params *RNAsnp_cmdline_parser_params_create(void);

/**
 * Initializes the passed RNAsnp_args_info structure's fields
 * (also set default values for options that have a default)
 * @param args_info the structure to initialize
 */
void RNAsnp_cmdline_parser_init (struct RNAsnp_args_info *args_info);
/**
 * Deallocates the string fields of the RNAsnp_args_info structure
 * (but does not deallocate the structure itself)
 * @param args_info the structure to deallocate
 */
void RNAsnp_cmdline_parser_free (struct RNAsnp_args_info *args_info);

/**
 * Checks that all the required options were specified
 * @param args_info the structure to check
 * @param prog_name the name of the program that will be used to print
 *   possible errors
 * @return
 */
int RNAsnp_cmdline_parser_required (struct RNAsnp_args_info *args_info,
  const char *prog_name);


#ifdef __cplusplus
}
#endif /* __cplusplus */
#endif /* RNASNP_CMDL_H */
