#ifndef GSL_EXT_H
#define GSL_EXT_H

#include <gsl/gsl_matrix.h>
#include <gsl/gsl_vector.h>
#include <gsl/gsl_linalg.h>
#include <assert.h>
#include <math.h>
#include <stdio.h>

#define INF 100000000
#define PRECISION 0.00000001

double add_log(double loga, double logb);

gsl_vector * vector_init(double* d, int size);
gsl_matrix * matrix_init(double** d, int size1,int size2);
double vector_vector_mul(gsl_vector *u, gsl_vector *v);
gsl_vector * matrix_vector_mul(gsl_matrix *m, gsl_vector *v);
gsl_vector * vector_matrix_mul(gsl_matrix *m, gsl_vector *v);
double vector_norm(gsl_vector *v);
double vector_sum(gsl_vector *v);
double matrix_sum(gsl_matrix *v);

/* functions at log scale */
double vector_vector_mul_log(gsl_vector *u, gsl_vector *v);
gsl_vector * matrix_vector_mul_log(gsl_matrix *m, gsl_vector *v);
gsl_vector * vector_matrix_mul_log(gsl_matrix *m, gsl_vector *v);



void matrix_log(gsl_matrix *m);
void vector_log(gsl_vector *v);
void matrix_unlog(gsl_matrix *m);

gsl_matrix * matrix_diag_mul(gsl_matrix *m, gsl_vector *D);
gsl_matrix * diag_matrix_mul(gsl_matrix *m, gsl_vector *D);
gsl_matrix * matrix_matrix_mul(gsl_matrix *m, gsl_matrix *n);
gsl_matrix* matrix_exp(gsl_vector* D, gsl_matrix* Q, double e);
void matrix_fprintf (FILE * stream, gsl_matrix * m);
void vector_fprintf (FILE * stream, gsl_vector * v);
void diag_fprintf (FILE * stream, gsl_vector * v);


void matrix_vector_mul_eq(gsl_vector*, gsl_matrix*, gsl_vector*);
void vector_outer_prod_eq(gsl_matrix*, gsl_vector*, gsl_vector*);
void matrix_vector_mul_log_eq(gsl_vector*, gsl_matrix *, gsl_vector *);
void diag_matrix_mul_eq(gsl_matrix*, gsl_matrix *, gsl_vector *);
void matrix_diag_mul_eq(gsl_matrix*, gsl_matrix *, gsl_vector *);




#endif
