#include "gsl_ext.h"
#include <string.h>
#define MAXLINE 1000

int map[]={0,3,2,1};

int translate(int i)
{
  int j=0;
  int n = 0;
  while ( i > 0){
    j |= map[i% 4] << 2*n;
    n++;
    i >>= 2;
  }
  return j;
}

int main(int argc, char* argv[])
{
  char* model_file = argv[1];
  int   dim = atoi(argv[2]);
  gsl_matrix *rm = gsl_matrix_alloc(dim, dim);
  gsl_vector *freq = gsl_vector_alloc(dim);
  gsl_matrix *new_rm = gsl_matrix_alloc(dim, dim);
  gsl_vector *new_freq = gsl_vector_alloc(dim);
  int  i,j;

  //Read rm and freq
  FILE * fin;
  char buffer[1000];
  char rm_tag[] = "Rate Matrix";
  char freq_tag[] = "Frequency";

  if ( (fin = fopen(model_file, "r") ) == NULL) 
    Die("Fail to read file %s", model_file);
  while(fgets(buffer,MAXLINE, fin) > 0) {    
    if (strncmp(buffer, rm_tag, strlen(rm_tag))== 0){
      gsl_matrix_fscanf(fin, rm);
      break;
    }
  }
  while(fgets(buffer,MAXLINE, fin) > 0) {    
    if (strncmp(buffer, freq_tag, strlen(freq_tag))== 0){
      gsl_vector_fscanf(fin, freq);      
      break;
    }    
  }
  for(i=0; i < rm->size1; i++)
    for(j=0; j < rm->size2; j++){      
      gsl_matrix_set(new_rm, translate(i), translate(j), gsl_matrix_get(rm, i,j));
    }

  for(i=0; i < freq->size; i++)
    gsl_vector_set(new_freq, translate(i), gsl_vector_get(freq, i));
  printf("Rate Matrix\n");
  matrix_fprintf(stdout, new_rm);
  printf("\nFrequency\n");
  vector_fprintf(stdout, new_freq);
}



