#ifndef _PHY_H
#define _PHY_H

#define MAX_CHILD 10
#define MAX_MODEL 10
#define SINGLE  0
#define PAIR    2
#include "squid.h"
#include "msa.h"
#include "gsl_ext.h"

#define MISSING     16   /* corresponds to 'N' in the alphabet */

struct phynode;

struct evo_model{
  double      scale;
  int         dim;
  gsl_matrix* rm;
  gsl_vector* freq;

  gsl_matrix* gap_rm;
  gsl_matrix* gap_Q0;  
  gsl_vector* gap_params;
};

typedef struct evo_model EvoModel;

extern EvoModel* single_model[MAX_MODEL];
extern EvoModel* pair_model[MAX_MODEL];
extern int single_model_num;
extern int pair_model_num;

struct phynode
{
  char      name[1000];
  float     weight;  
  float     length;
  struct phynode*  parent;  
  struct phynode*  children[MAX_CHILD];
  int       nchildren;  
  int       size;  
  
  int       seq_id;
  gsl_matrix* tm;
  gsl_vector* freq;

  gsl_matrix* single_tm[3];
  gsl_vector* single_freq[3];

  gsl_matrix* pair_tm[3];
  gsl_vector* pair_freq[3];

  gsl_vector* likelihood;
  double    loglikelihood;
  int       flag;  
};

typedef struct phynode PhyNode;

double ParseDouble(char** s);

PhyNode* ParseTree(char** str);

void PrintTree(PhyNode* p, char* indent);

PhyNode* ReadPhyFile(char* filename);

PhyNode** PhyLeaves(PhyNode* root);

void FreePhytree(PhyNode* node);

PhyNode* get_root(PhyNode* node);

void CalcWeight(PhyNode* node);

int EvoModel_read(char* filename, EvoModel* models[]);

void EvoModel_write(FILE* fout, char* format, EvoModel* models[], int nmodel);

void EvoModel_init_single_gap(EvoModel* mod);
void EvoModel_init_pair_gap(EvoModel* mod);

EvoModel* EvoModel_alloc(int mode, int use_gap);


void init_probability(PhyNode* node, int mode, int model_idx);

void EvoModel_free(EvoModel *e);

void alloc_node(PhyNode* node, int dim);
void clear_node(PhyNode* node);

void init_node(PhyNode* node, EvoModel* m, int use_gap);
void get_tm_freq(PhyNode* node, EvoModel* m, gsl_matrix* tm, gsl_vector* freq,int use_gap);


/*
void init_node_single_gap(PhyNode* node, EvoModel* single, int k);
void init_node_pair(PhyNode* node, EvoModel* pair);
void init_node_pair_gap(PhyNode* node, gsl_vector* gap_params, int single_model_idx, int pair_model_idx);
void init_node_single_gap_pair(PhyNode* node, EvoModel* single[], int nsingle, EvoModel* pair[], int npair);
*/

void init_leaves_single(PhyNode** leaves, int nleaves, int* seqid2leave, int nseq, int* coll);
void init_leaves_pair(PhyNode** leaves, int nleaves, int* seqid2leave, int nseq, int* coll, int* colr);


double null_loglikelihood(int nseq, int* col, gsl_vector* freq);
#endif
