#ifndef _PHY_H
#define _PHY_H

#include "squid.h"
#include "msa.h"


struct phynode;
#define MAX_CHILD 2
struct phynode
{
  char      name[1000];
  float     weight;  
  float     length;
  struct phynode*  parent;  
  struct phynode*  children[MAX_CHILD];
  int       nchildren;  
  int       size;    
  int       seq_id;
};

typedef struct phynode PhyNode;

double ParseDouble(char** s);

PhyNode* ParseTree(char** str);

void PrintTree(PhyNode* p, char* indent);

PhyNode* ReadPhyFile(char* filename);

PhyNode** PhyLeaves(PhyNode* root);

void FreePhytree(PhyNode* node);

PhyNode* root(PhyNode* node);

void CalcWeight(PhyNode* node);

#endif
