#include "phytree.h"
#include "grammar.h"
#include "funcs.h"
#include <float.h>
#include "/home/users/elfar/software/CMfinder_03/gsl/include/gsl/gsl_errno.h"
#include "/home/users/elfar/software/CMfinder_03/gsl/include/gsl/gsl_math.h"
#include "numerical_opt.h"


#include "squid.h"		/* general sequence analysis library    */
#include "msa.h"                /* squid's multiple alignment i/o       */
#include "structs.h"		/* data structures, macros, #define's   */
#include "funcs.h"		/* external functions                   */
#include "version.h"            /* versioning info for Infernal         */
#include "prior.h"
#include "../cmfinder/global.h"
#include <stdio.h>
#include <stdlib.h>
#define OUTBOUND -1

extern int logscale ;

int   pairs[]={0*4 + 3, 3*4 + 0, 1*4 + 2, 2*4 + 1, 2*4 + 3, 3*4 + 2};

int pair_id(int id)
{
  int i;
  for(i=0; i < 6; i++){
    if (id == pairs[i]) return i;
  }
  return -1;
}


int map_pair_freq_param[4][4]={{0, 1, 3, 6},
			      {1, 2, 4, 7},
			      {3, 4, 5, 8},
                              {6, 7, 8, 9}};

int map_pair_sub_param[6][6]={{-1,  0, 1,  2,  4, 5},
			      { 0, -1, 2,  1,  5, 4},
			      { 1,  2,-1,  3,  5, 7},
			      { 2,  1, 3, -1,  7, 6},
			      { 4,  5, 6,  7, -1, 8},
			      { 5,  4, 7,  6,  8,-1}
};




#define PAIR_PAM_NUM 23
#define PAIR_FREQ_PAM_NUM 9



double init_pair_params[PAIR_PAM_NUM]={0.00117, 0.001806, 0.000391, 0.001058, 0.266974, 0.000406, 0.177977, 0.000763, 0.049043, 0.002793,
			     7, 1, 80, 5,
			     1.03, 0.43, 1.87, 0.487, 5.586, 0.468, 0.3874, 4.73, 0.75
};



               
/* first 9 freq parameters (AU = UA). substitution: 15 cannonical basepair, 2 cannonical to non canonical
   (1/2 mutations), 1 noncanonical to noncanonical*/
int unpack_parameter_Evofold(const gsl_vector* params, EvoModel* mod)
{
  int i,j;
  int k=0;
  double tot_freq=0;
  double subs1, subs2, non_subs1, non_subs2;
  int pair_alphabet_size= Alphabet_size * Alphabet_size;

  for(i=0; i < params->size;i++){
    if (gsl_vector_get(params, k) < 0) return OUTBOUND;
  }
  for(i=0; i < Alphabet_size; i++) 
    for(j=0; j < Alphabet_size; j++){
      gsl_vector_set(mod->freq,i * Alphabet_size + j, gsl_vector_get(params,map_pair_freq_param[i][j]));	  
      tot_freq += gsl_vector_get(mod->freq,i * Alphabet_size + j);
    }

  gsl_vector_scale(mod->freq, 1/tot_freq);  
  k += PAIR_FREQ_PAM_NUM;
  subs1 = gsl_vector_get(params, k++);
  subs2 = gsl_vector_get(params, k++);
  non_subs1= gsl_vector_get(params,k++);
  non_subs2= gsl_vector_get(params, k++);
  
  for(i=0; i < pair_alphabet_size; i++){
    double tot=0;
    for(j=0; j < pair_alphabet_size; j++){
      if (i== j) continue;
      int l1,l2,p;
      l1 = pair_id(i);
      l2 = pair_id(j);
      if (l1>= 0 && l2 >=0){
	p = map_pair_sub_param[l1][l2];
	gsl_matrix_set(mod->rm, i, j, gsl_vector_get(params,k+p) * gsl_vector_get(mod->freq,j));
      }
      else{
	int subs = 2;
	if (abs(i-j) == 1 || abs(i-j)==4){
	  subs = 1;
	}
	if (l1 >=0 || l2 >= 0){
	  double v =  gsl_vector_get(mod->freq,j) *(subs ==1 ? subs1 : subs2);
	  gsl_matrix_set(mod->rm, i, j, v);	  
	}
	else{
	  double v =  gsl_vector_get(mod->freq,j) *(subs ==1 ? non_subs1 : non_subs2);
	  gsl_matrix_set(mod->rm, i, j, v);	  
	}
      }
      tot += gsl_matrix_get(mod->rm, i, j);
    }
    gsl_matrix_set(mod->rm, i, i, -tot);
  }
  EvoModel_init(mod);
  return 1;
}


int main(int argc, char* argv[])
{
  char* model_file= argv[1];
  
  char  buffer[MAXLINE];
  EvoModel* tmp_model[1];
  
  logscale = 0;

  EvoModel_read(model_file, tmp_model);  
  EvoModel* mod_pair = tmp_model[0];  

  int i,j,k,l;
  //gsl_vector* init = vector_init(init_pair_params, PAIR_PAM_NUM);
  EvoModel* mod_single = EvoModel_alloc(Alphabet_size);  
  gsl_vector_set_all(mod_single->freq, 0);  
  gsl_matrix_set_all(mod_single->rm, 0);  
  
  double u, v,frac;
  gsl_vector* freq_left = mod_single->freq;
  gsl_vector* freq_right = gsl_vector_alloc(Alphabet_size);
  gsl_vector_set_all(freq_left,0);
  gsl_vector_set_all(freq_right,0);
  
  for(i=0; i < Alphabet_size; i++){    
    for(j=0; j < Alphabet_size; j++){      
      v = gsl_vector_get(mod_pair->freq, Alphabet_size * i + j);
      gsl_vector_set(freq_left, i, v+ gsl_vector_get(freq_left, i));
      gsl_vector_set(freq_right, j, v+ gsl_vector_get(freq_right, j));
    }
  }
  
  gsl_vector_add(mod_single->freq, freq_right);
  gsl_vector_scale(mod_single->freq, 0.5);
  
  for(k=0; k < mod_pair->dim; k++){
    for(l=0; l < mod_pair->dim; l++){
      int i1,i2, j1, j2;
      i1 = k / Alphabet_size;
      i2 = k % Alphabet_size;
      j1 = l / Alphabet_size;
      j2 = l % Alphabet_size;
      
      v= gsl_matrix_get(mod_single->rm, i1, j1);
      u = gsl_matrix_get(mod_pair->rm, k, l);
      frac = gsl_vector_get(mod_pair->freq, k)/gsl_vector_get(mod_single->freq,i1);      
      gsl_matrix_set(mod_single->rm, i1, j1, v + u * frac);
		     
      printf("pair %d-%d, single %d-%d \t orig_rm %f  pair_rm %f  frac %f\t rm %f\n",
	     k,l, i1,j1, v,u, frac, v + u * frac);
      

      v= gsl_matrix_get(mod_single->rm, i2, j2);
      frac= gsl_vector_get(mod_pair->freq, k)/gsl_vector_get(mod_single->freq,i2);
      gsl_matrix_set(mod_single->rm, i2, j2, v + u * frac);
      
      printf("pair %d-%d, single %d-%d \t orig_rm %f  pair_rm %f  frac %.3f\t rm %f\n",
	     k,l, i2,j2, v,u, frac, v + u * frac);
      
    }
  }
  mod_single->scale = 1;
  tmp_model[0] = mod_single;
  EvoModel_write(stdout, "%.4f ", tmp_model, 1);
  
}



      
