#############################################################################################################
# R Script to plot block alignment from deepBlockAlign.                                                     #
# Args: 'aln file' 'PNG file', 'x-axis length', 'line start', 'line end', 'Query Id', 'Subject Id', 'Score' #
#############################################################################################################

ARGV <- commandArgs(TRUE)
d <- read.table(ARGV[1], sep="\t")
plot <- paste("", ARGV[2], sep="")
pdf(plot, width=2.4, height=2.2)

xcolor <- rep("darkred", ARGV[3])
ycolor <- rep("darkblue", ARGV[3])

#color <- c("Red", "Blue", "Green")
xcolor = as.numeric(d[ARGV[4]:ARGV[5],2] == -1)
xcolor[xcolor==1] <- "darkgreen"
xcolor[xcolor==0] <- "darkred"
ycolor = as.numeric(d[ARGV[4]:ARGV[5],3] == -1)
ycolor[ycolor==1] <- "darkgreen"
ycolor[ycolor==0] <- "darkblue"

linetype <- c(1, 4)
pointer <- c(1, 3)

qprofile = d[ARGV[4]:ARGV[5],2]
sprofile = d[ARGV[4]:ARGV[5],3]

#Get maximum expression for query and subject profile
qmax = max(d[ARGV[4]:ARGV[5],2]);
smax = max(d[ARGV[4]:ARGV[5],3]);

#Get the range for the x and y axis
xrange <- range(1:ARGV[3])
#yrange <- range(0,1.2)
yrange <- range(0, (max(qmax, smax)+0.2))

#Set up the plot
par(mgp = c(1.2, 0.5, 0), mar=c(2,2,1,2)+0.1)
plot(xrange, yrange, type="n", xlab="alignment coordinate", ylab="normalized read count", cex.lab=0.5, cex.axis=0.5)

qprofile[qprofile==-1] <- 0
sprofile[sprofile==-1] <- 0

#Add lines
#for(i in 2:3) {
	lines(d[ARGV[4]:ARGV[5],1], qprofile, type="l", lty=linetype[1], col=xcolor)
	points(d[ARGV[4]:ARGV[5],1], qprofile, col=xcolor, pch=pointer[1], cex=0.4)
	lines(d[ARGV[4]:ARGV[5],1], sprofile, type="l", lty=linetype[2], col=ycolor)
	points(d[ARGV[4]:ARGV[5],1], sprofile, col=ycolor, pch=pointer[2], cex=0.4)
#}

#Add title
plot_title <- paste("Block ", ARGV[9], " with ", ARGV[10], " (Score=", ARGV[8], ")", sep="");
grid(lwd=1)
title(main=plot_title, cex.main=0.5)

#Add a legend
legend(xrange[1], yrange[2], c(ARGV[6], ARGV[7], "gaps"), cex=0.3, col=c("darkred", "darkblue", "darkgreen"), pch=pointer, lty=linetype, bty="n")

garbage <- dev.off()
q()
