#include "fasta.h"

Fasta::Fasta(string filename, int dna, int gzip) {
  this->filename = filename;
  this->dna = dna;
  this->gzip = gzip;
}

void Fasta::getSeq(vector<string> &id, vector<string> &seq) {
  string fasta = "";
  string cat = "";
  int flag = 0;

  // Case: gzipped sequence input
  if (gzip == 1) {
    if (filename.find(".gz") == string::npos) {
      cout << "Error: " << filename << " is not in gzipped format.\n";
      exit(1);
    }

    string command = "gunzip -c " + filename;
    FILE *fp = popen(command.c_str(), "r");

    try {
      if (!fp) throw "File error: ";
    }

    catch (const char *e) {
      cout << e << filename << " cannot be opened.\n";
      exit(1);
    }

    __gnu_cxx::stdio_filebuf<char> *p_fb = new __gnu_cxx::stdio_filebuf<char>(fp, ios_base::in);
    istream input(static_cast<std::streambuf *>(p_fb));

    while (getline(input, fasta)) { // Automatically remove new line
      if (fasta.compare(0, 1, ">") == 0) {
	id.push_back(fasta.erase(0, 1));
	cat = "";
	flag = 0;
	continue;
      }

      else {
	for (int i=0; i<static_cast<int>(fasta.length()); i++) {
	  try {
	    if (isalpha(fasta.c_str()[i]) == 0) throw "Sequence type error: ";
	  }

	  catch (const char *e) {
	    cout << e << "The sequence must consist of alphabets.\n";
	    exit(1);
	  }

	  if (dna == 1) {
	    if (fasta.compare(i, 1, "T") == 0) fasta.replace(i, 1, "U");
	    if (fasta.compare(i, 1, "t") == 0) fasta.replace(i, 1, "u");
	  }
	} // i

	cat = cat + fasta;

	if (flag == 0) {
	  seq.push_back(cat);
	  flag = 1;
	}

	else if (flag == 1) {
	  seq.pop_back();
	  seq.push_back(cat);
	}
      }
    } // End of "while"

    delete p_fb;
    pclose(fp);
  }

  // Case: RNA or DNA sequence input
  else {
    ifstream fin;
    fin.open(filename.c_str());

    try {
      if (!fin) throw "File error: ";
    }

    catch (const char *e) {
      cout << e << filename << " cannot be opened.\n";
      exit(1);
    }

    while (getline(fin, fasta)) { // Automatically remove new line
      if (fasta.compare(0, 1, ">") == 0) {
	id.push_back(fasta.erase(0, 1));
	cat = "";
	flag = 0;
	continue;
      }

      else {
	for (int i=0; i<static_cast<int>(fasta.length()); i++) {
	  try {
	    if (isalpha(fasta.c_str()[i]) == 0) throw "Sequence type error: ";
	  }

	  catch (const char *e) {
	    cout << e << "The sequence must consist of alphabets.\n";
	    exit(1);
	  }

	  if (dna == 1) {
	    if (fasta.compare(i, 1, "T") == 0) fasta.replace(i, 1, "U");
	    if (fasta.compare(i, 1, "t") == 0) fasta.replace(i, 1, "u");
	  }
	} // i

	cat = cat + fasta;

	if (flag == 0) {
	  seq.push_back(cat);
	  flag = 1;
	}

	else if (flag == 1) {
	  seq.pop_back();
	  seq.push_back(cat);
	}
      }
    } // End of "while"

    fin.close();
  }

  try {
    for (int i=0; i<static_cast<int>(seq.size()); i++) {
      if (seq[i].length() < 5) throw "Sequence length error: ";
    }
  }

  catch (const char *e) {
    cout << "The minimum length of each sequence is 5 due to the internal calculation of energy of a hairpin loop.\n";
    exit(0);
  }

  #if DEBUG
  cout << id[0] << endl << seq[0] << endl << "Length = " << seq[0].length() << endl << "\n";
  #endif
}
