#include <iostream>
#include <string>
#include <algorithm>
#include "option.h"
#include "fasta.h"
#include "localprob.h"
#include "alignment.h"
#include "score.h"

using namespace std;

int main(int argc, char *argv[]) {
  Option opt = Option();
  argc = opt.parseOption(argc, argv);

  // Input at most two (gzipped) FASTA files
  string filename1 = opt.getFilename(1);
  int dna = opt.getDNA();
  int gzip = opt.getGzip();
  Fasta fasta1 = Fasta(filename1, dna, gzip);
  vector<string> id1, id2, seq1, seq2;
  fasta1.getSeq(id1, seq1);

  if (argc == 2) {
    string filename2 = opt.getFilename(2);
    Fasta fasta2 = Fasta(filename2, dna, gzip);
    fasta2.getSeq(id2, seq2);
  }

  int entire = opt.getEntire();
  int region = opt.getRegion();
  int align = opt.getAlign();
  int verbose = opt.getVerbose();

  int winsize = opt.getWinsize();
  int pairsize = opt.getPairsize();
  int step = opt.getStep();
  float cutoffb = opt.getCutoffb();
  float nu = opt.getNu();
  int diagsize = opt.getDiagsize();
  double thres = opt.getThres();
  int match = opt.getMatch();
  int mismatch = opt.getMismatch();
  int gapd = opt.getGapd();
  int cutoff = opt.getCutoff();

  Score sc = Score(cutoffb, nu, diagsize, thres, align, match, mismatch, gapd, cutoff, region, step, entire, verbose);

  // Check
  if (argc == 1 && seq1.size() == 1) {
    cout << "Error: at least two sequences must be contained in one multi-FASTA file if you enter just one file.\n";
    exit(1);
  }

  if (entire == 1 && region == 1) {
    cout << "Error: the options \"-e\" and \"-r\" are not compatible.\n";
    exit(1);
  }

  vector<map<Positions, vector<int> > > interval1; // Vector of interval lists
  interval1.resize(seq1.size());

  // Calculate binary sequences for potential structured RNA regions in one multi-FASTA file
  for (int i=0; i<static_cast<int>(seq1.size()); i++) {
    if (entire == 1) {
      if (seq1[i].length() > 300) {
	winsize = 300;
	pairsize = 300;
      }

      else {
	winsize = seq1[i].length();
	pairsize = winsize;
      }
    }

    sc.calcRegion(interval1[i], id1[i], seq1[i], winsize, pairsize);
  } // i

  vector<vector<int> > score; // Score matrix

  // Calculate alignment scores between two binary sequences within one multi-FASTA file
  if (argc == 1 && region == 0) {
    for (int i=0; i<static_cast<int>(seq1.size())-1; i++) {
      for (int j=i+1; j<static_cast<int>(seq1.size()); j++) {
	sc.calcScore(score, interval1[i], interval1[j], id1[i], id1[j]);
	score.clear();
      } // j
    } // i
  } // argc == 1

  else if (argc == 2) {
    vector<map<Positions, vector<int> > > interval2; // Vector of interval lists
    interval2.resize(seq2.size());

    // Calculate binary sequences for potential structured RNA regions in the other (multi-)FASTA file
    for (int i=0; i<static_cast<int>(seq2.size()); i++) {
      if (entire == 1) {
	if (seq2[i].length() > 300) {
	  winsize = 300;
	  pairsize = 300;
	}

	else {
	  winsize = seq2[i].length();
	  pairsize = winsize;
	}
      }

	sc.calcRegion(interval2[i], id2[i], seq2[i], winsize, pairsize);
    } // i

    // Calculate alignment scores between two binary sequences across two FASTA files
    for (int i=0; i<static_cast<int>(seq1.size()); i++) {
      for (int j=0; j<static_cast<int>(seq2.size()); j++) {
	sc.calcScore(score, interval1[i], interval2[j], id1[i], id2[j]);
	score.clear();
      } // j
    } // i
  } // argc == 2

  return 0;
}
