#ifndef __LOCALPROB_H__
#define __LOCALPROB_H__
#include <iostream>
#include <string>
#include <map>
#include <vector>
#include <algorithm>
#include <sstream>
#include <iomanip>
#include <cstdlib>
#include <cmath>
#define DEBUG 0

using namespace std;

namespace Vienna {
extern "C" {
#include <ViennaRNA/utils.h>
#include <ViennaRNA/fold.h>
#include <ViennaRNA/fold_vars.h>
#include <ViennaRNA/LPfold.h>
#include <ViennaRNA/part_func.h>
#include <ViennaRNA/params.h>
};
}; // Vienna

class Positions {
public:
  int left, right;
  Positions(int left, int right);
  bool operator<(const Positions &rhs) const;
};

class LocalProb {
private:
  string id, seq;
  int winsize, pairsize, diagsize, region, verbose;
  float cutoffb, nu;
  double thres;
public:
  LocalProb(string id, string seq, int winsize, int pairsize, float cutoffb, float nu, int diagsize, double thres, int region, int verbose);
  void calcLocalProb(map<Positions, double> &prob);
  void enumCandidate(map<Positions, double> &candidate, map<Positions, double> &prob);
  void slideWindow(map<Positions, vector<int> > &interval, int step);
  void nonOverlap(map<Positions, vector<int> > &interval, map<Positions, double> &candidate);
  void makeVector(map<Positions, vector<int> > &interval, map<Positions, double> &prob);
};

void makeInterval(map<Positions, vector<int> > &interval, int left, int right);
void traverseDiagonally(vector<vector<double> > &diag, map<Positions, double> &prob, int k, int l, int did);
void integrate(vector<int> &ivect, vector<vector<double> > &diag1, vector<vector<double> > &diag2, int k, int l, int diagsize, double thres);
int getBinary(vector<double> &cell, double thres);
//int getBinary1(vector<double> &cell);
//int getBinary3(vector<double> &cell);
#endif
