#ifndef __OPTION_H__
#define __OPTION_H__
#include <iostream>
#include <string>
#include <getopt.h>
#include <cstdlib>

using namespace std;

class Option {
private:
  string filename1, filename2;
  int dna, gzip, entire, region, align, verbose, winsize, pairsize, step, diagsize, match, mismatch, gapd, cutoff;
  float cutoffb, nu;
  double thres;
public:
  Option();
  int parseOption(int argc, char **argv);
  void showHelp();
  void showFullHelp();
  string getFilename(int id);
  int getDNA();
  int getGzip();
  int getEntire();
  int getRegion();
  int getAlign();
  int getVerbose();
  int getWinsize();
  int getPairsize();
  int getStep();
  float getCutoffb();
  float getNu();
  int getDiagsize();
  double getThres();
  int getMatch();
  int getMismatch();
  int getGapd();
  int getCutoff();
};
#endif
