#ifndef __SCORE_H__
#define __SCORE_H__
#include <vector>
#include "localprob.h"
#include "alignment.h"
#define DEBUG 0

using namespace std;

class Score {
private:
  int diagsize, align, match, mismatch, gapd, cutoff, region, step, entire, verbose;
  float cutoffb, nu;
  double thres;
public:
  Score(float cutoffb, float nu, int diagsize, double thres, int align, int match, int mismatch, int gapd, int cutoff, int region, int step, int entire, int verbose);
  void calcRegion(map<Positions, vector<int> > &interval, string id, string seq, int winsize, int pairsize);
  void calcScore(vector<vector<int> > &score, map<Positions, vector<int> > &interval1, map<Positions, vector<int> > &interval2, string id1, string id2);
};

int dotProduct(vector<int> x, vector<int> y, int cutoff);
#endif
