#ifndef MBLLIST
#define MBLLIST

#include "foldalign.h"

/******************************************************************************
*                                                                             *
*   Copyright 2004 - 2007 Jakob Hull Havgaard, hull@genome.ku.dk              *
*                                                                             *
*   This file is part of Foldalign                                            *
*                                                                             *
*   Foldalign is free software; you can redistribute it and/or modify         *
*   it under the terms of the GNU General Public License as published by      *
*   the Free Software Foundation; either version 2 of the License, or         *
*   (at your option) any later version.                                       *
*                                                                             *
*   Foldalign is distributed in the hope that it will be useful,              *
*   but WITHOUT ANY WARRANTY; without even the implied warranty of            *
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             *
*   GNU General Public License for more details.                              *
*                                                                             *
*   You should have received a copy of the GNU General Public License         *
*   along with Foldalign; if not, write to the Free Software                  *
*   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA *
*                                                                             *
******************************************************************************/

class mbllist {
public:

	inline mbllist()
		: sli(0), slk(0), slWi(0), slWk(0),
		  sri(0), srk(0), srWi(0), srWk(0), 
		  sscore(big_neg) {};
		  
	inline mbllist(positionType ri, positionType rk,
						lengthType rWi, lengthType rWk,
						positionType li, positionType lk,
						lengthType lWi, lengthType lWk,
						scoreType score) :
			sli(li), slk(lk), slWi(lWi), slWk(lWk), 
			sri(ri), srk(rk), srWi(rWi), srWk(rWk), 
			sscore(score) {};
	
	inline void get(positionType& ri, positionType& rk,
				  lengthType& rWi, lengthType& rWk, 
				  positionType& li, positionType& lk,
				  lengthType& lWi, lengthType& lWk, 
				  scoreType& score) {
		li = sli; lk = slk; lWi = slWi; lWk = slWk;
		ri = sri; rk = srk; rWi = srWi; rWk = srWk;
		score = sscore;
	}
		
private:

	positionType sli;
	positionType slk;
	lengthType slWi;
	lengthType slWk;
	positionType sri;
	positionType srk;
	lengthType srWi;
	lengthType srWk;
	scoreType sscore;

};

#endif /* MBLLIST */
