#ifndef QUE_SLL
#define QUE_SLL

#include "exception.cxx"

#include <iostream>
#include <string>

/******************************************************************************
*                                                                             *
*   Copyright 2004 - 2007 Jakob Hull Havgaard, hull@genome.ku.dk              *
*                                                                             *
*   This file is part of Foldalign                                            *
*                                                                             *
*   Foldalign is free software; you can redistribute it and/or modify         *
*   it under the terms of the GNU General Public License as published by      *
*   the Free Software Foundation; either version 2 of the License, or         *
*   (at your option) any later version.                                       *
*                                                                             *
*   Foldalign is distributed in the hope that it will be useful,              *
*   but WITHOUT ANY WARRANTY; without even the implied warranty of            *
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             *
*   GNU General Public License for more details.                              *
*                                                                             *
*   You should have received a copy of the GNU General Public License         *
*   along with Foldalign; if not, write to the Free Software                  *
*   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA *
*                                                                             *
******************************************************************************/

template< class item, class index>
class que_sll {

public:
	que_sll() : head(0), tail(0), num(0) {};
	
	void shift(const item value) {

		if (tail == 0) {
			tail = new node();
			head = tail;
		}
		else {
			tail->next = new node();
			tail = tail->next;
		}

		tail->value = value;
		tail->next = 0;
		
		num++;
	}	
	
	item unshift() {
	
		if (head == 0) {
			std::string error = "Program error! Que underflow";
			throw exception(error, false);
		}
		
		item element = head->value;
		node* old_head = head;
		head = head->next;
		if (head == 0) {tail = 0;}
		
		num--;
		
		delete old_head;
		return element;
		
	}
	
	index size() const {return num;}
	
	~que_sll() {
	
		while (head != 0) {
			node* next = head->next;
			delete head;
			head = next;
		}

	};
	
private:

	struct node {
		item value;
		node* next;
	};
	
	node* head;
	node* tail;
	
	index num;

};


#endif /* QUE_SLL */
