#ifndef EUKBASEPAIRMODEL_H_
#define EUKBASEPAIRMODEL_H_

#include <Phyl/AbstractSubstitutionModel.h>

#include "BasePairGapAlphabet.h"

namespace ptr
{

class EukBasePairGapModel : public bpp::AbstractReversibleSubstitutionModel {
public:
	EukBasePairGapModel(BasePairGapAlphabet * a);
	~EukBasePairGapModel();
	
	#ifndef NO_VIRTUAL_COV
  	EukBasePairGapModel*
	#else
  	bpp::Clonable*
	#endif
 	clone()  const { return new EukBasePairGapModel(new BasePairGapAlphabet()); }
 	
 	std::string getName() const { return "Euk_BPGM"; }
 	unsigned int getNumberOfStates() const { return size_; }
 	void setFreq(float * f);
 	void update() { updateMatrices(); }
 	
 	std::map<std::string,int> row;
	std::map<int,std::string> rrow;
	BasePairGapAlphabet * bpa;
	
	//void updateMatrices();
 	
};

}

#endif /*EUKBASEPAIRMODEL_H_*/
