#include <NumCalc/MatrixTools.h>
#include <NumCalc/VectorTools.h>
#include <NumCalc/EigenValue.h>

#include "HKY85GapModel.h"
#include "Log.h"

namespace ptr
{

HKY85GapModel::HKY85GapModel(DNAGapAlphabet * a, float k)  : bpp::AbstractSubstitutionModel(a, "HYK85Gap.") {
	LOG(lTRACE) << "HKY85GapModel constructor start"; 
	alpha = a;
	kappa = k;
	
	row["A"] = 0;	rrow[0] = "A";
	row["G"] = 1;	rrow[1] = "G";
	row["C"] = 2;	rrow[2] = "C";
	row["T"] = 3;	rrow[3] = "T";
	row["U"] = 3;
	row["-"] = 4;	rrow[4] = "-";
	row["."] = 4;
	
	
 	LOG(lTRACE) << "HKY85GapModel constructor end";
}

void HKY85GapModel::setFreq(float * f) {
	LOG(lTRACE) << "HKY85GapModel::setFreq start"; 
	
   for(unsigned int i = 0; i < size_; i++) {
   	 freq_[alpha->charToInt(rrow[i])] = f[i];
   	 LOG(lTRACE) << i << " " << rrow[i] << " "  << alpha->charToInt(rrow[i]) << " " << f[i] << " " <<  freq_[alpha->charToInt(rrow[i])];
   }
   
   LOG(lTRACE) << "HKY85GapModel::setFreq end";
}

void HKY85GapModel::update(){ 
	
	LOG(lTRACE) << "HKY85GapModel::update start";
// update matrices	
	
	
	//LOG(lTRACE) << exchangeability_.getNumberOfRows() << " " << exchangeability_.getNumberOfColumns();
	float pi_G = freq_[alpha->charToInt("G")];
	float pi_A = freq_[alpha->charToInt("A")];
	float pi_C = freq_[alpha->charToInt("C")];
	float pi_T = freq_[alpha->charToInt("T")];
	float gap  = freq_[alpha->charToInt("-")];
	
	// diag = negative row sum
	double diag_A = -1 * (kappa*pi_G + pi_C + pi_T + gap);
	double diag_G = -1 * (kappa*pi_A + pi_C + pi_T + gap);
	double diag_C = -1 * (pi_A + pi_G + kappa*pi_T + gap);
	double diag_T = -1 * (pi_A + pi_G + kappa*pi_C + gap);
	double diag_gap = -1 * (pi_A + pi_G + pi_C + pi_T);
	
	
	//                  A             G             C           T	        gap
	double x[] =  {  diag_A   ,  kappa * pi_G ,    pi_C     ,   pi_T       , gap,        // A
				   kappa*pi_A ,    diag_G     ,    pi_C     ,   pi_T       , gap,        // G
			          pi_A    ,    pi_G       ,   diag_C    , kappa*pi_T   , gap,		// C	
				      pi_A    ,    pi_G       ,  kappa*pi_C ,  diag_T      , gap,	    // T
				      pi_A     ,   pi_G       ,    pi_C      ,   pi_T      , diag_gap};	// gap
	
	for(int col = 0; col < 5; col++) {
		int e_col = alpha->charToInt(rrow[col]);
		for(int row = 0; row < 5; row++) {
			int e_row = alpha->charToInt(rrow[row]);
			generator_(e_row,e_col) = x[row*5 + col]; 
		}
		int index = col * (5+1);
		generator_(e_col,e_col) = x[index]; // diagonal elements
	}
	
	LOG(lTRACE) << "Rate Matrix (generator_)" << std::endl;
	/*for(int col = 0; col < 5; col++) {
		std::cout << "\t" << alpha->intToChar(col);	
	}
	std::cout << std::endl;
	
	for(int row = 0; row < 5; row++) {
		std::cout << alpha->intToChar(row);	
		for(int col = 0; col < 5; col++) {
	 		std::cout << "\t" << generator_(row,col);
		}
		std::cout << std::endl;
	}*/
	
	// Normalization:
	double r = 1. / (2. * (pi_A * pi_C + pi_C * pi_G + pi_A * pi_T + pi_G * pi_T + kappa * (pi_C * pi_T + pi_A * pi_G)));
	bpp::MatrixTools::scale(generator_, r);   
	  	 
	// test auf reversibilty  pi_i * Q_ij = pi_j * Q_ji
	LOG(lTRACE) << "Testing reversibility of rate matrix for HKY85+Gap model";
	for(int row = 0; row < size_; row++) {
		for(int col = 0; col < size_; col++) {
			double x =  Qij( alpha->charToInt(rrow[row]), alpha->charToInt(rrow[col]));
			double y =  Qij(alpha->charToInt(rrow[col]), alpha->charToInt(rrow[row]));
			LOG(lTRACE) << x << " "<< y << " " << freq_[alpha->charToInt(rrow[row])] << " " << freq_[alpha->charToInt(rrow[col])] << " " <<x * freq_[alpha->charToInt(rrow[row])] - y * freq_[alpha->charToInt(rrow[col])];
		}		
	}
	
	// calc eigenvectors
	AbstractSubstitutionModel::updateMatrices();
	
	
	
	LOG(lTRACE) << "HKY85GapModel::update end";
	
}



HKY85GapModel::~HKY85GapModel() {

	LOG(lTRACE2) << "HKY85GapModel destructor start"; 
	if(alpha != NULL)
		delete alpha;	
	LOG(lTRACE2) << "HKY85GapModel destructor end"; 
}




}
