#include "PairedHKY85GapSubstitutionModel.h"
#include "Log.h"
using namespace std;

namespace ptr
{
	
bool PairedHKY85GapSubstitutionModel::canHandleGaps() {
	return true;	
}
	

PairedHKY85GapSubstitutionModel::PairedHKY85GapSubstitutionModel(double kappa) {
	LOG(lTRACE)  << "paired hky85 specific constructor start ";
	
	this->size = 25;
	this->kappa = kappa;
	
	row["AA"] = 0; rrow[0] = "AA";
	row["AC"] = 1; rrow[1] = "AC";
	row["AG"] = 2; rrow[2] = "AG";
	row["AT"] = 3; rrow[3] = "AT";
	row["AU"] = 3; 
	row["CA"] = 4; rrow[4] = "CA";	
	row["CC"] = 5; rrow[5] = "CC";
	row["CG"] = 6; rrow[6] = "CG";	
	row["CT"] = 7; rrow[7] = "CT";
	row["CU"] = 7; 
	row["GA"] = 8; rrow[8] = "GA";	
	row["GC"] = 9; rrow[9] = "GC";
	row["GG"] = 10; rrow[10] = "GG";	
	row["GT"] = 11; rrow[11] = "GT";
	row["GU"] = 11; 
	row["TA"] = 12; rrow[12] = "TA";	
	row["TC"] = 13; rrow[13] = "TC";
	row["TG"] = 14; rrow[14] = "TG";	
	row["TT"] = 15; rrow[15] = "TT";
	row["UA"] = 12; 	
	row["UC"] = 13; 
	row["UG"] = 14; 	
	row["UU"] = 15; 
	row["A-"] = 16; rrow[16] = "A-";	
	row["A."] = 16; 
	row["C-"] = 17; rrow[17] = "C-";
	row["C."] = 17; 
	row["G-"] = 18; rrow[18] = "G-";	
	row["G."] = 18; 
	row["T-"] = 19; rrow[19] = "T-";
	row["T."] = 19; 
	row["U-"] = 19; 	
	row["U."] = 19; 
	row["-A"] = 20; rrow[20] = "-A";
	row[".A"] = 20; 
	row["-C"] = 21; rrow[21] = "-C";	
	row[".C"] = 21; 
	row["-G"] = 22; rrow[22] = "-G";
	row[".G"] = 22; 
	row["-T"] = 23; rrow[23] = "-T";
	row[".T"] = 23; 
	row["-U"] = 23; 
	row[".U"] = 23; 
	row["--"] = 24; rrow[24] = "--";
	row[".."] = 24; 
	
	this->hky85 = new HKY85GapSubstitutionModel(kappa);
	LOG(lTRACE)  << "paired hky85 specific constructor end ";
	
}

PairedHKY85GapSubstitutionModel::~PairedHKY85GapSubstitutionModel() {
	delete hky85;
}

double PairedHKY85GapSubstitutionModel::P(int i, int j, double t, double mu){ 
	
	
	string pair1 = rrow[i];
	string pair2 = rrow[j];
	
	//cout << "pair1 = " << pair1 << endl;
	//cout << "pair2 = " << pair2 << endl;
	
	string pair1_base1 = string(1,pair1[0]);
	string pair1_base2 = string(1,pair1[1]);
	//cout << "pair1 base1 = " << pair1_base1 << "(" << row[""+pair1_base1] << ")  base 2 = " << pair1_base2 <<"("<< row[pair1_base2] << ")" << endl;
	
	string pair2_base1 = string(1,pair2[0]);
	string pair2_base2 = string(1,pair2[1]);
	//cout << "pair2 base1 = " << pair2_base1 << "(" << row[pair2_base1] << ")  base 2 = " << pair2_base2 <<"("<< row[pair2_base2] << ")" << endl;
			
	
	double hky85value_pair1 = hky85->P(row[pair1_base1], row[pair1_base2], t, mu);
	double hky85value_pair2 = hky85->P(row[pair2_base1], row[pair2_base2], t, mu);
	//cout << "prob for " << pair1_base1 << "->" << pair1_base2 <<" is " << hky85value_pair1 << endl;
	//cout << "prob for " << pair2_base1 << "->" << pair2_base2 <<" is " << hky85value_pair2 << endl;
	
	return hky85value_pair1 * hky85value_pair2;
}

void PairedHKY85GapSubstitutionModel::init() {
	LOG(lTRACE) << "paired hky85 init start";
	
	hky85->setFreq(freq);
	hky85->init();
	
	
		
}





}
