#ifndef BASEPAIRGAPALPHABET_H_
#define BASEPAIRGAPALPHABET_H_

#include <Seq/AbstractAlphabet.h>
#include "DNAGapAlphabet.h"

namespace ptr {

class BasePairGapAlphabet : public bpp::AbstractAlphabet {
public:
	BasePairGapAlphabet();
	~BasePairGapAlphabet();
	
	
	unsigned int getSize() const { return 20; }

    
    unsigned int getNumberOfTypes() const { return 21; }
     
    int getUnknownCharacterCode() const { return 20; }
 
    bool isUnresolved(int state) const { return state == 20; }
    bool isUnresolved(const std::string & state) const { return charToInt(state) == 20; }
    std::string getAlphabetType() const { return "BasePairGapAlphabet"; }
    	
	std::map<std::string,int> row;
	std::map<int,std::string> rrow;
	
};

} // end namespace

#endif /*BASEPAIRGAPALPHABET_H_*/
