#include "DNAGapAlphabet.h"

#include <Seq/AbstractAlphabet.h>
#include <Seq/NucleicAlphabetState.h>

#include "Log.h"

namespace ptr
{

DNAGapAlphabet::DNAGapAlphabet()
{
	LOG(lTRACE) << "DNAGapAlphabet Constructor start";
	
	resize(7);
	setState( 0, bpp::NucleicAlphabetState(-1, ".",  0, "Gap"));
	setState( 1, bpp::NucleicAlphabetState( 0, "A",  1, "Adenine"));
	setState( 2, bpp::NucleicAlphabetState( 1, "C",  2, "Cytosine"));
	setState( 3, bpp::NucleicAlphabetState( 2, "G",  4, "Guanine"));
	setState( 4, bpp::NucleicAlphabetState( 3, "T",  8, "Thymine"));
	setState( 5, bpp::NucleicAlphabetState( 4, "-",  0, "Gap"));
	setState( 6, bpp::NucleicAlphabetState(14, "N", 15, "Unresolved base"));
			
	LOG(lTRACE) << "DNAGapAlphabet Constructor end";
}

DNAGapAlphabet::~DNAGapAlphabet()
{
	LOG(lTRACE) << "DNAGapAlphabet Destructor";	
}

}
