#ifndef DNAGAPALPHABET_H_
#define DNAGAPALPHABET_H_

#include <Seq/LetterAlphabet.h>

namespace ptr {

class DNAGapAlphabet : public bpp::LetterAlphabet {
public:
	DNAGapAlphabet();
	~DNAGapAlphabet();

	unsigned int getSize() const { return 5; }

    
    unsigned int getNumberOfTypes() const { return 7; }
     
    int getUnknownCharacterCode() const { return 14; }
 
    bool isUnresolved(int state) const { return state > 4; }
    bool isUnresolved(const std::string & state) const { return charToInt(state) > 4; }
    std::string getAlphabetType() const { return "DNA+Gap alphabet"; }
    
};

} // end namespace

#endif /*DNAGAPALPHABET_H_*/
