#ifndef HKY85GAPMODEL_H_
#define HKY85GAPMODEL_H_

#include <Phyl/AbstractSubstitutionModel.h>

#include "DNAGapAlphabet.h"

namespace ptr
{

class HKY85GapModel : public bpp::AbstractSubstitutionModel {
public:
	HKY85GapModel(DNAGapAlphabet * a, float kappa);
	~HKY85GapModel();
	
	#ifndef NO_VIRTUAL_COV
  	HKY85GapModel*
	#else
  	bpp::Clonable*
	#endif
 	clone()  const { return new HKY85GapModel(new DNAGapAlphabet(), kappa); }
 	
 	std::string getName() const { return "HKY85GapModel"; }
 	unsigned int getNumberOfStates() const { return 5; }
 	void setFreq(float * f);
 	void update();
 	
 	std::map<std::string,int> row;
	std::map<int,std::string> rrow;
	DNAGapAlphabet * alpha;

protected:
	float kappa;
 	
};

}

#endif /*HKY85GAPMODEL_H_*/
