#include <memory.h>

#include "HKY85GapSubstitutionModel.h"
#include "Log.h"

using namespace std;

namespace ptr
{
	
bool HKY85GapSubstitutionModel::canHandleGaps() {
	return true;	
}
	

// constructor
// alpha is transition, beta is transversion which means that beta is the kappa in some notations
// usually transition is 1, and beta (kappa) a real value
HKY85GapSubstitutionModel::HKY85GapSubstitutionModel(double kappa) {
	LOG(lTRACE)  << "HKY85GapSubstitutionModel constructor start";	
	this->kappa = kappa;
	this->size = 5;
	
	row["A"] = 0;	rrow[0] = "A";
	row["G"] = 1;	rrow[1] = "G";
	row["C"] = 2;	rrow[2] = "C";
	row["T"] = 3;	rrow[3] = "T";
	row["U"] = 3;
	row["-"] = 4;	rrow[4] = "-";
	row["."] = 4;
	
	DNAGapAlphabet * d = new DNAGapAlphabet();
	hky85gapmodel = new HKY85GapModel(d, kappa); 
	
	LOG(lTRACE)  << "HKY85GapSubstitutionModel constructor end";
}

HKY85GapSubstitutionModel::~HKY85GapSubstitutionModel() {
	LOG(lTRACE)  << "HKY85GapSubstitutionModel destructor start";	
	
	if(hky85gapmodel != NULL)
		delete  hky85gapmodel; 
	
	LOG(lTRACE)  << "HKY85GapSubstitutionModel destructor end";
}


double HKY85GapSubstitutionModel::P(int from, int to, double t, double mu){ 

	return hky85gapmodel->Pij_t(hky85gapmodel->getAlphabet()->charToInt(rrow[from]), hky85gapmodel->getAlphabet()->charToInt(rrow[to]), t*mu); 
		
}


void HKY85GapSubstitutionModel::init() {
	LOG(lTRACE)  << "HKY85GapSubstitutionModel init start";
	
	hky85gapmodel->update();	
	
	// test auf reversibilty  pi_i * P_ij = pi_j * P_ji
	LOG(lTRACE) << "Testing reversibility of probability matrix for HKY85+Gap model";
	for(int row = 0; row < size; row++) {
		for(int col = 0; col < size; col++) {
			double x = hky85gapmodel->Pij_t(hky85gapmodel->getAlphabet()->charToInt(rrow[row]), hky85gapmodel->getAlphabet()->charToInt(rrow[col]), 0.3);
			double y = hky85gapmodel->Pij_t(hky85gapmodel->getAlphabet()->charToInt(rrow[col]), hky85gapmodel->getAlphabet()->charToInt(rrow[row]), 0.3);
			LOG(lTRACE) << x << " "<< y << " " << freq[row] << " " << freq[col] << " " <<x * freq[row] - y * freq[col];
		}		
	}
		
	LOG(lTRACE)  << "HKY85GapSubstitutionModel init end";
}


void HKY85GapSubstitutionModel::setFreq(float *f) {
	LOG(lTRACE)  << "HKY85GapSubstitutionModel setFreq start";
	freq = f;	
	hky85gapmodel->setFreq(f);
	LOG(lTRACE)  << "HKY85GapSubstitutionModel setFreq end";
}



}
