#include <memory.h>

#include "HKY85SubstitutionModel.h"
#include "Log.h"

using namespace std;

namespace ptr
{
	
bool HKY85SubstitutionModel::canHandleGaps() {
	return false;	
}
	


// alpha is transition, beta is transversion which means that beta is the kappa in some notations
// usually transition is 1, and beta (kappa) a real value
HKY85SubstitutionModel::HKY85SubstitutionModel(double kappa) {
	LOG(lTRACE)  << "hky85 specific constructor start";	
	this->kappa = kappa;
	this->size = 4;
	
	row["A"] = 0;	rrow[0] = "A";
	row["G"] = 1;	rrow[1] = "G";
	row["C"] = 2;	rrow[2] = "C";
	row["T"] = 3;	rrow[3] = "T";
	row["U"] = 3;
	
	
	LOG(lTRACE)  << "hky85 specific constructor end";
}


double HKY85SubstitutionModel::P(int from, int to, double t, double mu){ 
	
	double p = model->Pij_t(model->getAlphabet()->charToInt(rrow[from]), model->getAlphabet()->charToInt(rrow[to]), t*mu); 
	
	return p;
	
}


void HKY85SubstitutionModel::init() {
	LOG(lTRACE)  << "hky85 init start";
	
	// now we know the freqs and the kappa, so can init bpp::HKY85
	bpp::DNA *dna = new bpp::DNA();
	model = new bpp::HKY85(dna, kappa, freq[row["A"]], freq[row["C"]], freq[row["G"]], freq[row["T"]]);
	
	LOG(lTRACE) << "HKY85 kappa=" << model->getParameterValue("kappa");
	
	LOG(lTRACE)  << "hky85 init end";
}


}
