#include <memory.h>

#include "PairedEukSSUrRNAGapSubstitutionModel.h"
#include "Log.h"
#include "BasePairGapAlphabet.h"
#include "BasePairModel.h"

using namespace std;

namespace ptr
{


bool PairedEukSSUrRNAGapSubstitutionModel::canHandleGaps() {
	return true;	
}

PairedEukSSUrRNAGapSubstitutionModel::PairedEukSSUrRNAGapSubstitutionModel()
{
	LOG(lTRACE)   << "PairedEukSSUrRNAGapSubstitutionModel generic constructor start";
	this->size = 25;

	row["A-"] = 0; rrow[0] = "A-";
	row["A."] = 0;
	row["C-"] = 1; rrow[1] = "C-";
	row["C."] = 1;
	row["G-"] = 2; rrow[2] = "G-";
	row["G."] = 2; rrow[2] = "G-";
	row["T-"] = 3; rrow[3] = "T-";
	row["T."] = 3;
	row["U-"] = 3;
	row["U."] = 3;
	
	row["AA"] = 10; rrow[10] = "AA";
	row["AC"] = 11; rrow[11] = "AC";
	row["AG"] = 12; rrow[12] = "AG";
	row["AT"] = 4; rrow[4] = "AT";
	row["AU"] = 4; 
	row["CA"] = 13;  rrow[13] = "CA";	
	row["CC"] = 14; rrow[14] = "CC";
	row["CG"] = 9;  rrow[9] = "CG";	
	row["CT"] = 15;  rrow[15] = "CT";
	row["CU"] = 15; 
	row["GA"] = 16; rrow[16] = "GA";	
	row["GC"] = 6; rrow[6] = "GC";
	row["GG"] = 17; rrow[17] = "GG";	
	row["GT"] = 5; rrow[5] = "GT";
	row["GU"] = 5; 
	row["TA"] = 7; rrow[7] = "TA";	
	row["TC"] = 18; rrow[18] = "TC";
	row["TG"] = 8; rrow[8] = "TG";	
	row["TT"] = 19; rrow[19] = "TT";
	row["UA"] = 7; 	
	row["UC"] = 18; 
	row["UG"] = 8; 	
	row["UU"] = 19; 
		
	row["-A"] = 20; rrow[20] = "-A";
	row[".A"] = 20; 
	row["-C"] = 21; rrow[21] = "-C";	
	row[".C"] = 21; 
	row["-G"] = 22; rrow[22] = "-G";
	row[".G"] = 22; 
	row["-T"] = 23; rrow[23] = "-T";
	row[".T"] = 23; 
	row["-U"] = 23; 
	row[".U"] = 23; 
	row["--"] = 24; rrow[24] = "--";
	row[".."] = 24; 
	
	BasePairGapAlphabet * bpa = new BasePairGapAlphabet();	
	bpm = new EukBasePairGapModel(bpa);
	
	LOG(lTRACE)   << "PairedEukSSUrRNAGapSubstitutionModel generic constructor end";
}

PairedEukSSUrRNAGapSubstitutionModel::~PairedEukSSUrRNAGapSubstitutionModel() {
	LOG(lTRACE) << "PairedEukSSUrRNAGapSubstitutionModel destructor start";
	if(bpm != NULL)
		delete bpm;
	LOG(lTRACE) << "PairedEukSSUrRNAGapSubstitutionModel destructor end";
}

double PairedEukSSUrRNAGapSubstitutionModel::P(int from, int to, double t, double mu){ 

	if(from == 24 || to == 24) { 
		if(from == 24 && to == 24) { // from -- to --
			// P(--|--) = P(-|-) * P(-|-)
			double p = hky85->P(hky85->row["-"], hky85->row["-"],t, mu) * hky85->P(hky85->row["-"], hky85->row["-"],t, mu);
			LOG(lTRACE2) << rrow[from] << " -> " << rrow[to] << " = " << p;
			return p;
		}
		else if(from == 24 && (to >= 4 && to <= 19)) { // from -- to XX
			// P(XX|--) = P(X-|--) * P(XX|X-) + P(-X|--) * P(XX|-X)
			//make those X- and -X strings:
			
			string x1 =  string(1,(rrow[to])[0]);
			string x2 =  string(1,(rrow[to])[1]);
			string x_ = x1 + "_"; 
			string _x = "_" + x2;
			
			if(to >= 20) to -= 20;
			
			double p = hky85->P(hky85->row["-"], hky85->row[x1],t, mu)
					* bpm->Pij_t(bpm->getAlphabet()->charToInt(rrow[row[x_]]), bpm->getAlphabet()->charToInt(rrow[to]), t*mu)
					+ hky85->P(hky85->row["-"], hky85->row[x2],t, mu)
					* bpm->Pij_t(bpm->getAlphabet()->charToInt(rrow[row[_x]]), bpm->getAlphabet()->charToInt(rrow[to]), t*mu);
			
			LOG(lTRACE2) << rrow[from] << " -> " << rrow[to] << " = " << p;
			return p; 
						
		}
		else if((from >= 4 && from <= 19) && to == 24) { // from XX to -- 	 
			// P(--|XX) = P(X-|XX) * P(-|X) + P(-X|XX) * P(-|X)
			
			string x1 =  string(1,(rrow[from])[0]);
			string x2 =  string(1,(rrow[from])[1]);
			string x_ =  x1 + "_"; 
			string _x =  "_" + x2;
			
			if(from >= 20) from -= 20; 
			
			LOG(lTRACE2) <<  bpm->Pij_t(bpm->getAlphabet()->charToInt(rrow[from]),bpm->getAlphabet()->charToInt(rrow[row[x_]]), t*mu);
			LOG(lTRACE2) << hky85->P(hky85->row[x1], hky85->row["-"],t, mu);
			LOG(lTRACE2) <<  bpm->Pij_t(bpm->getAlphabet()->charToInt(rrow[from]), bpm->getAlphabet()->charToInt(rrow[row[_x]]), t*mu);
			LOG(lTRACE2) << hky85->P(hky85->row[x2],hky85->row["-"] ,t, mu);
			double p = bpm->Pij_t(bpm->getAlphabet()->charToInt(rrow[from]),bpm->getAlphabet()->charToInt(rrow[row[x_]]), t*mu)
					* hky85->P(hky85->row[x1], hky85->row["-"],t, mu)
					+ bpm->Pij_t(bpm->getAlphabet()->charToInt(rrow[from]), bpm->getAlphabet()->charToInt(rrow[row[_x]]), t*mu) 
					* hky85->P(hky85->row[x2],hky85->row["-"] ,t, mu);
			LOG(lTRACE2) << rrow[from] << " -> " << rrow[to] << " = " << p;	 
			return p;	 
		}
		else { 	// if change from -- to X-|-X, then use the HKY85Gap
			if(from == 24 ) { // if change from -- to X-
				string x;
				if(to < 20)  // X-
					 x = string(1,(rrow[to])[0]);
				else  // -X
					 x = string(1,(rrow[to])[1]);
				
				double p = hky85->P(hky85->row["-"],hky85->row[x] ,t, mu);
				LOG(lTRACE2) << rrow[from] << " -> " << rrow[to] << " = " << p;
				return p;	 
			}
			else { // if change from  X-|-X to -- , then use the HKY85Gap
				string x;
				if(from < 20)  // X-
					 x = string(1,(rrow[from])[0]);
				else  // -X
					 x = string(1,(rrow[from])[1]);
				double p = hky85->P(hky85->row[x], hky85->row["-"] ,t, mu);
				LOG(lTRACE2) << rrow[from] << " -> " << rrow[to] << " = " << p;
				return p;	 
				 
			}
			cerr << "This position should never be reached" << endl;
			exit(1);
		}			
	} 
	else {	
		if((from < 4 && to >19)) {  // from Y- to -X 
			// P(-X|Y-) = P(-|Y) * P(X|-) 
			string y =  string(1,(rrow[from])[0]);
			string x =  string(1,(rrow[to])[1]);
			double p = hky85->P(hky85->row[y],hky85->row["-"],t, mu) * hky85->P(hky85->row["-"],hky85->row[x],t, mu);
			LOG(lTRACE2) << rrow[from] << " -> " << rrow[to] << " = " << p;	
			return p;	
			
		}
		else if((from >19 && to <4)) {  // from -Y to X- 
			//P(X-|-Y) = P(X|-) * P(-|Y)
			string x =  string(1,(rrow[to])[0]);
			string y =  string(1,(rrow[from])[1]);
			double p = hky85->P(hky85->row["-"], hky85->row[x] ,t, mu) * hky85->P(hky85->row[y], hky85->row["-"] ,t, mu);
			LOG(lTRACE2) << rrow[from] << " -> " << rrow[to] << " = " << p;	
			return p;	
		}
		else if((from < 4 && to <4)) {  // from Y- to X- 
			//P(X-|Y-) = P(X|Y) * P(-|-)
			string x =  string(1,(rrow[to])[0]);
			string y =  string(1,(rrow[from])[0]);
			double p = hky85->P(hky85->row[y], hky85->row[x] ,t, mu) * hky85->P(hky85->row["-"], hky85->row["-"] ,t, mu);
			LOG(lTRACE2) << y << " -> " << x << " = " << hky85->P(hky85->row[y], hky85->row[x] ,t, mu);
			LOG(lTRACE2) << "-" << " -> " << "-" << " = " << hky85->P(hky85->row["-"], hky85->row["-"] ,t, mu);
			LOG(lTRACE2) << rrow[from] << " -> " << rrow[to] << " = " << p;	
			return p;	
			
		}
		else if((from >19 && to >19)) {  // from -Y to -X 
			//P(-X|-Y) = P(-|-) * P(X|Y)
			string x =  string(1,(rrow[to])[1]);
			string y =  string(1,(rrow[from])[1]);
			double p =  hky85->P(hky85->row["-"], hky85->row["-"] ,t, mu) * hky85->P(hky85->row[y], hky85->row[x] ,t, mu);
			LOG(lTRACE2) << rrow[from] << " -> " << rrow[to] << " = " <<hky85->P(hky85->row["-"], hky85->row["-"] ,t, mu) * hky85->P(hky85->row[y], hky85->row[x] ,t, mu);	
			return p;	
			
		}
		else {
			// XX to XX or XX to X- or XX to -X or vice versa
			if(from >= 20) from -= 20; 
			if(to >= 20) to -= 20;
			double p =  bpm->Pij_t(bpm->getAlphabet()->charToInt(rrow[from]), bpm->getAlphabet()->charToInt(rrow[to]), t*mu);
			LOG(lTRACE2) << rrow[from] << " -> " << rrow[to] << " = " << p;		
			return p;
		}
	} 
		
}


void PairedEukSSUrRNAGapSubstitutionModel::init() {
	LOG(lTRACE)  << "PairedEukSSUrRNA init start";
	
	bpm->update();
	
	// test auf reversibilty  pi_i * Pij = pi_j * Pji
	/*for(int row = 0; row < size; row++) {
		for(int col = 0; col < size; col++) {
			int f = row;
			int t = col;
			if(f >= 20) f -= 20; 
			if(t >= 20) t -= 20;
			double x = bpm->Pij_t(bpm->getAlphabet()->charToInt(rrow[f]), bpm->getAlphabet()->charToInt(rrow[t]), 0.3);
			double y = bpm->Pij_t(bpm->getAlphabet()->charToInt(rrow[t]), bpm->getAlphabet()->charToInt(rrow[f]), 0.3);
			LOG(lTRACE) << x << " "<< rrow[f] << " " << y << " " << rrow[t] << " " << freq[f] << " " << freq[t] << " " <<x * freq[f] - y * freq[t];
		}		
	}*/
	
	/*for(int row = 0; row < 20; row++) {
		double sum = 0;
		for(int col = 0; col < 20; col++) {
			int f = row;
			int t = col;
			sum +=  bpm->Pij_t(bpm->getAlphabet()->charToInt(rrow[f]), bpm->getAlphabet()->charToInt(rrow[t]), 0.3);
			double x = bpm->Pij_t(bpm->getAlphabet()->charToInt(rrow[f]), bpm->getAlphabet()->charToInt(rrow[t]), 0.3);
			double y = bpm->Pij_t(bpm->getAlphabet()->charToInt(rrow[t]), bpm->getAlphabet()->charToInt(rrow[f]), 0.3);
			LOG(lTRACE) << rrow[f] << " to " << rrow[t] <<  " = " << x; 
			//LOG(lTRACE) << x << " "<< rrow[f] << " " << y << " " << rrow[t] << " " << freq[f] << " " << freq[t] << " " <<x * freq[f] - y * freq[t];
		}		
		LOG(lTRACE) << row << " "<< rrow[row] << " sum=" << sum;
	}*/
	 		
	LOG(lTRACE)  << "PairedEukSSUrRNA init end";
}

void PairedEukSSUrRNAGapSubstitutionModel::setFreq(float *f) {
	LOG(lTRACE)  << "PairedEukSSUrRNA setFreq start";
	freq = f;	
	//frequencies that are not covered in bpm, e.g.  -C should be added to C- here and then passed to bpm
	/*freq[0] += freq[20];
	freq[1] += freq[21];
	freq[2] += freq[22];
	freq[3] += freq[23];*/
	bpm->setFreq(freq);
	LOG(lTRACE)  << "PairedEukSSUrRNA setFreq end";
}



}
