#ifndef PAIREDEUKSSURRNAGAPSUBSTITUTIONMODEL_H_
#define PAIREDEUKSSURRNAGAPSUBSTITUTIONMODEL_H_

#include "HKY85GapSubstitutionModel.h"
#include "SubstitutionModel.h"
#include "EukBasePairGapModel.h"

namespace ptr
{

class PairedEukSSUrRNAGapSubstitutionModel : public SubstitutionModel {

public:
	PairedEukSSUrRNAGapSubstitutionModel();
	~PairedEukSSUrRNAGapSubstitutionModel();
	void init();
	double P(int i, int j, double t, double mu);
	bool canHandleGaps();
	void setFreq(float * freq);
	void setHKY85GapSubstitutionModel(HKY85GapSubstitutionModel * h) { this->hky85 = h; }
private:
	EukBasePairGapModel * bpm;
	HKY85GapSubstitutionModel * hky85;
};

}

#endif /*PAIREDEUKSSURRNAGAPSUBSTITUTIONMODEL_H_*/
