#include <NumCalc/MatrixTools.h>
#include <NumCalc/VectorTools.h>
#include <NumCalc/EigenValue.h>

#include "ProBasePairModel.h"
#include "Log.h"

namespace ptr
{

ProBasePairModel::ProBasePairModel(BasePairAlphabet * a)  : bpp::AbstractReversibleSubstitutionModel(a, "ProrRNA.") {

	bpa = a;
	
	row["AA"] = 6; rrow[6] = "AA";
	row["AC"] = 7; rrow[7] = "AC";
	row["AG"] = 8; rrow[8] = "AG";
	row["AT"] = 0; rrow[0] = "AT";
	row["AU"] = 0; 
	row["CA"] = 9;  rrow[9] = "CA";	
	row["CC"] = 10; rrow[10] = "CC";
	row["CG"] = 5;  rrow[5] = "CG";	
	row["CT"] = 11;  rrow[11] = "CT";
	row["CU"] = 11; 
	row["GA"] = 12; rrow[12] = "GA";	
	row["GC"] = 2; rrow[2] = "GC";
	row["GG"] = 13; rrow[13] = "GG";	
	row["GT"] = 1; rrow[1] = "GT";
	row["GU"] = 1; 
	row["TA"] = 3; rrow[3] = "TA";	
	row["TC"] = 14; rrow[14] = "TC";
	row["TG"] = 4; rrow[4] = "TG";	
	row["TT"] = 15; rrow[15] = "TT";
	row["UA"] = 3; 	
	row["UC"] = 14; 
	row["UG"] = 4; 	
	row["UU"] = 15; 



	LOG(lTRACE) << exchangeability_.getNumberOfRows() << " " << exchangeability_.getNumberOfColumns();
//  prokaryotes
	//                AU     GU    GC   UA   UG   CG  AA     AC   AG      CA     CC    CU      GA     GG      UC     UU
	double x[] =  {   0 ,  6.8 , 9.4,  8.7, 3.4, 4.8, 9.7,  8.2,  2.5,   2.9,   4.6,  28.1,    2.1,   3.9,    7.0,   8.5, 
		              0 ,  0   , 4.0,  1.6, 2.9, 1.2, 6.7, 10.3,  4.4,   4.3,   4.1,  18.5,    2.4,  18.5,   13.8,   4.4,
		              0 ,  0   ,  0 ,  2.0, 1.5, 1.8, 3.1,  3.0,  0.6,   1.5,  10.4,   1.6,    0.9,   2.0,   16.7,   1.1,
		              0 ,  0   ,  0 ,   0 , 9.3, 7.6, 7.3,  1.6,  1.1,  12.5,   0.4,   8.5,    2.1,   4.9,   41.8,   5.0,
		              0 ,  0   ,  0 ,   0 ,  0 , 6.1, 9.0,  1.8,  2.2,  15.8,  48.3,   5.6,    0.9,   9.3,   23.0,   8.4,
		              0 ,  0   ,  0 ,   0 ,  0 ,  0 , 1.7,  0.8,  1.1,   9.2,  11.2,  14.0,    1.2,   6.2,    1.9,   4.9,
		              0 ,  0   ,  0 ,   0 ,  0 ,  0 ,  0 , 38.9, 95.3, 102.4,  26.6, 111.6,  223.5, 615.4,   51.4,  20.2,
		              0 ,  0   ,  0 ,   0 ,  0 ,  0 ,  0 ,   0 , 21.2,  15.5,  49.3, 138.5,    3.6,  67.5,   51.2,   5.6,
		              0 ,  0   ,  0 ,   0 ,  0 ,  0 ,  0 ,   0 ,  0  ,   8.7,   7.3,  54.3,   20.9,  27.4,   13.4,   1.5,
		              0 ,  0   ,  0 ,   0 ,  0 ,  0 ,  0 ,   0 ,  0  ,   0  , 103.5, 120.1,   20.5,   5.0,   48.2,   6.4,
		              0 ,  0   ,  0 ,   0 ,  0 ,  0 ,  0 ,   0 ,  0  ,   0  ,   0  , 143.1,    4.1,  12.2,  214.7, 144.8,
		              0 ,  0   ,  0 ,   0 ,  0 ,  0 ,  0 ,   0 ,  0  ,   0  ,   0  ,   0  ,   31.5,  33.0, 1373.1, 107.5,
		              0 ,  0   ,  0 ,   0 ,  0 ,  0 ,  0 ,   0 ,  0  ,   0  ,   0  ,   0  ,     0 ,  12.0,   30.5,   5.9,
		              0 ,  0   ,  0 ,   0 ,  0 ,  0 ,  0 ,   0 ,  0  ,   0  ,   0  ,   0  ,     0 ,   0  ,  106.0,   6.9,
		              0 ,  0   ,  0 ,   0 ,  0 ,  0 ,  0 ,   0 ,  0  ,   0  ,   0  ,   0  ,     0 ,   0  ,   0   ,   59.3,
		              0 ,  0   ,  0 ,   0 ,  0 ,  0 ,  0 ,   0 ,  0  ,   0  ,   0  ,   0  ,     0,    0  ,   0   ,    0   };         
	
	
	
	// fill in the lower triangle of the matrix:
	// TODO this code is just copied from Euk 
	 for(int row = 0; row < 15; row++) {
		for(int col = row; col < 16; col++) {
			int index = row * 16 + col;
			int index_twin = index - ( (16-1)*row - (16-1)*col );
			x[index_twin] = x[index];	
		}
	}
		
	// sum of rows = sum of columns
	for(int col = 0; col < 16; col++) {
		int e_col = a->charToInt(rrow[col]);
		double sum = 0;
		for(int row = 0; row < 16; row++) {
			sum += x[row*16 + col];
			int e_row = a->charToInt(rrow[row]);
			exchangeability_(e_row,e_col) = x[row*16 + col]; 
			exchangeability_(e_col,e_row) = x[row*16 + col];
		}
		int index = col * (16+1);
		x[index] = -1 * sum;	
		exchangeability_(e_col,e_col) = -1 *sum;
	}
	
	//cout << exchangeability_ << endl;
	for(int col = 0; col < 16; col++) {
		std::cout << "\t" << a->intToChar(col);	
	}
	std::cout << std::endl;
	
	for(int row = 0; row < 16; row++) {
		std::cout << a->intToChar(row);	
		for(int col = 0; col < 16; col++) {
	 		std::cout << "\t" << exchangeability_(row,col);
		}
		std::cout << std::endl;
	}
 	
}

void ProBasePairModel::setFreq(float * f) {
	
	LOG(lTRACE) << "ProBasePairModel::setFreq (pseudoCount) start"; 
	
   for(unsigned int i = 0; i < size_; i++) {
   	 freq_[bpa->charToInt(rrow[i])] = f[i];
   	 //LOG(lTRACE) << i << " " << rrow[i] << " "  << bpa->charToInt(rrow[i]) << " " << f[i] << " " <<  freq_[bpa->charToInt(rrow[i])];
   }
	LOG(lTRACE) << "ProBasePairModel::setFreq (pseudoCount) end";
	
}

ProBasePairModel::~ProBasePairModel() {

	LOG(lTRACE2) << "ProBasePairModel destructor start"; 
	if(bpa != NULL)
		delete bpa;	
	LOG(lTRACE2) << "ProBasePairModel destructor end"; 
}




}
