#ifndef SUBSTITUTIONMODEL_
#define SUBSTITUTIONMODEL_

#include <string>
#include <map>
#include <iostream>

namespace ptr {

class SubstitutionModel {

private:

protected:
	int size;
  	float *freq;
  	
  	
public:
	virtual double P(int i, int j, double t, double mu) = 0;  //prob. of changing from state i to j over time t with rate mu
	int getMatrixSize();
	virtual ~SubstitutionModel();
	virtual void init() = 0;
	std::map<std::string,int> row;
	std::map<int,std::string> rrow;
	virtual void setFreq(float * freq);
	virtual void setPairedFreq(float * freq) { };
	virtual void setUnpairedFreq(float * freq) { };
	float* getFreq();
	virtual bool canHandleGaps() = 0;

}; // end class SubstitutionModel

} // end namespace ptr
	
	
#endif /*SUBSTITUTIONMODEL_*/
