#include <iostream>
#include <fstream>
#include <sstream>
#include <string.h>
#include <stdio.h>

#include "Log.h"

using namespace ptr;

// die zeile muss unbedingt da sein
TLogLevel Log::globalLevel = lDEBUG;
const char* Log::logLevelNames[] = { "ERROR", "WARN", "INFO", "DEBUG", "TRACE", "TRACE2", "TRACE3" };

std::ostringstream& Log::Get(TLogLevel level, int nr, std::string file) {
   if(level >= lDEBUG) {
   	os << "[" << file << ":" << nr << " " <<logLevelNames[level] << "] ";
   }
   //messageLevel = level;
   return os;
}
Log::Log() {
	
}

Log::~Log() {
  // if (messageLevel >= globalLevel) {
      os << std::endl;
      fprintf(stdout, "%s", os.str().c_str());
      fflush(stdout);
   //}
}


void Log::setLogLevel(char *newlevel) {
   
   if(strcmp(newlevel,"error") == 0) {
   		globalLevel = lERROR;
   }
   else if(strcmp(newlevel,"warn") == 0) {
   		globalLevel = lWARN;
   }
   else if(strcmp(newlevel,"info") == 0) {
   		globalLevel = lINFO;
   }
   else if(strcmp(newlevel,"debug") == 0) {
   		globalLevel = lDEBUG;
   }
   else if(strcmp(newlevel,"trace") == 0) {
   		globalLevel = lTRACE;
   }
   else if(strcmp(newlevel,"trace2") == 0) {
   		globalLevel = lTRACE2;
   }
   else if(strcmp(newlevel,"trace3") == 0) {
   		globalLevel = lTRACE3;
   }
   
}


