#ifndef PROBASEPAIRMODEL_H_
#define PROBASEPAIRMODEL_H_

#include <Phyl/AbstractSubstitutionModel.h>

#include "BasePairAlphabet.h"

namespace ptr
{

class ProBasePairModel : public bpp::AbstractReversibleSubstitutionModel {
public:
	ProBasePairModel(BasePairAlphabet * a);
	~ProBasePairModel();
	
	#ifndef NO_VIRTUAL_COV
  	ProBasePairModel*
	#else
  	bpp::Clonable*
	#endif
 	clone()  const { return new ProBasePairModel(new BasePairAlphabet()); }
 	
 	std::string getName() const { return "Pro_BPM"; }
 	unsigned int getNumberOfStates() const { return 16; }
 	void setFreq(float * f);
 	void update() { updateMatrices(); }
 	
 	std::map<std::string,int> row;
	std::map<int,std::string> rrow;
	BasePairAlphabet * bpa;
	
	//void updateMatrices();
 	
};

}

#endif /*PROBASEPAIRMODEL_H_*/
