#include "BasePairGapAlphabet.h"
#include "Log.h"

#include <Seq/AlphabetState.h>

namespace ptr
{


BasePairGapAlphabet::BasePairGapAlphabet()
{
	LOG(lTRACE) << "BasePairGapAlphabet Constructor start";
	
	resize(21);
	
	
	row["A-"] = 0; rrow[0] = "A-";
	row["-A"] = 0;
	row["C-"] = 1; rrow[1] = "C-";
	row["-C"] = 1;
	row["G-"] = 2; rrow[2] = "G-";
	row["-G"] = 2;
	row["T-"] = 3; rrow[3] = "T-";
	row["-T"] = 3;
	row["U-"] = 3;
	row["-U"] = 3;
	
	row["AA"] = 10; rrow[10] = "AA";
	row["AC"] = 11; rrow[11] = "AC";
	row["AG"] = 12; rrow[12] = "AG";
	row["AT"] = 4; rrow[4] = "AT";
	row["AU"] = 4; 
	row["CA"] = 13;  rrow[13] = "CA";	
	row["CC"] = 14; rrow[14] = "CC";
	row["CG"] = 9;  rrow[9] = "CG";	
	row["CT"] = 15;  rrow[15] = "CT";
	row["CU"] = 15; 
	row["GA"] = 16; rrow[16] = "GA";	
	row["GC"] = 6; rrow[6] = "GC";
	row["GG"] = 17; rrow[17] = "GG";	
	row["GT"] = 5; rrow[5] = "GT";
	row["GU"] = 5; 
	row["TA"] = 7; rrow[7] = "TA";	
	row["TC"] = 18; rrow[18] = "TC";
	row["TG"] = 8; rrow[8] = "TG";	
	row["TT"] = 19; rrow[19] = "TT";
	row["UA"] = 7; 	
	row["UC"] = 18; 
	row["UG"] = 8; 	
	row["UU"] = 19;
	
	for(unsigned int i = 0; i < 20; i++) {
		setState( i, bpp::AlphabetState(i, rrow[i], rrow[i]));
	}
	setState( 20, bpp::AlphabetState(20, "NN", "NN"));	
	
	LOG(lTRACE) << "BasePairGapAlphabet Constructor end";	
}

BasePairGapAlphabet::~BasePairGapAlphabet()
{
	LOG(lTRACE) << "BasePairGapAlphabet Destructor";	
}

}
