#ifndef BASEPAIRMODEL_H_
#define BASEPAIRMODEL_H_

#include <Phyl/AbstractSubstitutionModel.h>

#include "BasePairAlphabet.h"

namespace ptr
{

class BasePairModel : public bpp::AbstractReversibleSubstitutionModel {
public:
	BasePairModel(BasePairAlphabet * a);
	~BasePairModel();
	
	#ifndef NO_VIRTUAL_COV
  	BasePairModel*
	#else
  	bpp::Clonable*
	#endif
 	clone()  const { return new BasePairModel(new BasePairAlphabet()); }
 	
 	std::string getName() const { return "Euk_BPM"; }
 	unsigned int getNumberOfStates() const { return 16; }
 	void setFreq(float * f);
 	void update() { updateMatrices(); }
 	
 	std::map<std::string,int> row;
	std::map<int,std::string> rrow;
	BasePairAlphabet * bpa;
	
	//void updateMatrices();
 	
};

}

#endif /*BASEPAIRMODEL_H_*/
