#ifndef LOG_H_
#define LOG_H_

#define LOG(level) if (level > Log::globalLevel) ; else Log().Get(level,__LINE__,__FILE__) 

#include <iostream>
#include <sstream>
#include <fstream>
#include <string>
#include <stdio.h>

namespace ptr {
enum TLogLevel {lERROR, lWARN, lINFO, lDEBUG, lTRACE, lTRACE2, lTRACE3};


class Log {
public:
   Log();
   virtual ~Log();
   std::ostringstream& Get(TLogLevel level = lINFO, int = 0, std::string file = "");
   static TLogLevel globalLevel;
   static void setLogLevel(char *newlevel);
   static const char* logLevelNames[];
protected:
   std::ostringstream os;
private:
   Log(const Log&);
   Log& operator =(const Log&);
//private:
 //  TLogLevel messageLevel; // war fuer den Fall ohne MACRO LOG()
};



}
#endif /*LOG_H_*/
