#include <NumCalc/MatrixTools.h>
#include <NumCalc/VectorTools.h>
#include <NumCalc/EigenValue.h>

#include "EukBasePairGapModel.h"
#include "Log.h"

namespace ptr
{

EukBasePairGapModel::EukBasePairGapModel(BasePairGapAlphabet * a)  : bpp::AbstractReversibleSubstitutionModel(a, "EukrRNAGap.") {

	bpa = a;
	//size_ = 20;
	
	row["A-"] = 0; rrow[0] = "A-";
	row["-A"] = 0;
	row["C-"] = 1; rrow[1] = "C-";
	row["-C"] = 1;
	row["G-"] = 2; rrow[2] = "G-";
	row["-G"] = 2;
	row["T-"] = 3; rrow[3] = "T-";
	row["-T"] = 3;
	row["U-"] = 3;
	row["-U"] = 3;
	
	row["AA"] = 10; rrow[10] = "AA";
	row["AC"] = 11; rrow[11] = "AC";
	row["AG"] = 12; rrow[12] = "AG";
	row["AT"] = 4; rrow[4] = "AT";
	row["AU"] = 4; 
	row["CA"] = 13;  rrow[13] = "CA";	
	row["CC"] = 14; rrow[14] = "CC";
	row["CG"] = 9;  rrow[9] = "CG";	
	row["CT"] = 15;  rrow[15] = "CT";
	row["CU"] = 15; 
	row["GA"] = 16; rrow[16] = "GA";	
	row["GC"] = 6; rrow[6] = "GC";
	row["GG"] = 17; rrow[17] = "GG";	
	row["GT"] = 5; rrow[5] = "GT";
	row["GU"] = 5; 
	row["TA"] = 7; rrow[7] = "TA";	
	row["TC"] = 18; rrow[18] = "TC";
	row["TG"] = 8; rrow[8] = "TG";	
	row["TT"] = 19; rrow[19] = "TT";
	row["UA"] = 7; 	
	row["UC"] = 18; 
	row["UG"] = 8; 	
	row["UU"] = 19; 



	LOG(lTRACE) << size_ << " " << exchangeability_.getNumberOfRows() << " " << exchangeability_.getNumberOfColumns();
	// eukaryotes
	//                -A    -C    -G    -U      AU    GU    GC    UA     UG     CG      AA     AC     AG     CA      CC    CU      GA    GG     UC   UU
  double x[] =  {   0.0 , 0.0 , 0.0 , 0.0   ,  0  ,  0  ,  0  ,  0   ,  0   ,  0   ,   0   ,  0   ,  0   ,  0   ,   0  ,  0   ,   0  ,  0   ,  0 ,  0,  // -A 
                    0.0 , 0.0 , 0.0 , 0.0   ,  0  ,  0  ,  0  ,  0   ,  0   ,  0   ,   0   ,  0   ,  0   ,  0   ,   0  ,  0   ,   0  ,  0   ,  0 ,  0,  // -C 
                    0.0 , 0.0 , 0.0 , 0.0   ,  0  ,  0  ,  0  ,  0   ,  0   ,  0   ,   0   ,  0   ,  0   ,  0   ,   0  ,  0   ,   0  ,  0   ,  0 ,  0,  // -G 
                    0.0 , 0.0 , 0.0 , 0.0   ,  0  ,  0  ,  0  ,  0   ,  0   ,  0   ,   0   ,  0   ,  0   ,  0   ,   0  ,  0   ,   0  ,  0   ,  0 ,  0,  // -U 
                    0.0 , 0.0 , 0.0 , 0.0   ,  0  ,  0  ,  0  ,  0   ,  0   ,  0   ,   0   ,  0   ,  0   ,  0   ,   0  ,  0   ,   0  ,  0   ,  0 ,  0,  // AU 
                    0.0 , 0.1 , 0.2 , 0.1   , 6.4 ,  0  ,  0  ,  0   ,  0   ,  0   ,   0   ,  0   ,  0   ,  0   ,   0  ,  0   ,   0  ,  0   ,  0 ,  0,  // GU 
                    0.0 , 0.1 , 0.1 , 0.0   , 4.5 , 6.2 ,  0  ,  0   ,  0   ,  0   ,   0   ,  0   ,  0   ,  0   ,   0  ,  0   ,   0  ,  0   ,  0 ,  0,  // GC
                    0.0 , 0.1 , 0.0 , 0.1   , 3.1 , 1.2 , 1.7 ,  0   ,  0   ,  0   ,   0   ,  0   ,  0   ,  0   ,   0  ,  0   ,   0  ,  0   ,  0 ,  0,  // UA
                    0.0 , 0.2 , 0.2 , 0.2   , 1.4 , 1.3 , 1.3 , 5.2  ,  0   ,  0   ,   0   ,  0   ,  0   ,  0   ,   0  ,  0   ,   0  ,  0   ,  0 ,  0,  // UG
                    0.0 , 0.2 , 0.1 , 0.1   , 2.1 , 1.1 , 1.7 , 5.6  , 6.4  ,  0   ,   0   ,  0   ,  0   ,  0   ,   0  ,  0   ,   0  ,  0   ,  0 ,  0,  // CG
                    0.1 , 0.1 , 0.1 , 0.0   , 5.8 , 3.5 , 2.1 , 6.4  , 9.2  , 1.5  ,   0   ,  0   ,  0   ,  0   ,   0  ,  0   ,   0  ,  0   ,  0 ,  0,  // AA
                    0.1 , 0.1 , 0.1 , 0.1   , 13.3, 13.7, 7.5 , 1.6  , 8.3  , 0.1  , 50.2  ,  0   ,  0   ,  0   ,   0  ,  0   ,   0  ,  0   ,  0 ,  0,  // AC
                    0.2 , 0.4 , 0.2 , 0.2   , 10.7, 6.6 , 4.0 , 3.3  , 15.3 , 7.0  , 110.5 , 32.5 ,  0   ,  0   ,   0  ,  0   ,   0  ,  0   ,  0 ,  0,  // AG
                    0.0 , 0.2 , 0.1 , 0.1   , 0.8 , 1.2 , 1.6 , 13.5 , 5.8  , 11.2 , 9.1   , 6.9  , 2.5  ,  0   ,   0  ,  0   ,   0  ,  0   ,  0 ,  0,  // CA
                    0.0 , 0.6 , 0.3 , 0.1   , 2.8 , 3.2 , 6.1 , 1.4  , 3.9  , 4.4  , 1.9   , 42.9 , 6.2  , 3.1  ,   0  ,  0   ,   0  ,  0   ,  0 ,  0,  // CC
                    0.1 , 0.3 , 0.2 , 0.1   , 4.8 , 5.0 , 1.4 , 3.1  , 8.9  , 3.8  , 4.1   , 34.0 , 12.1 , 81.8 , 46.0 ,  0   ,   0  ,  0   ,  0 ,  0,  // CU
                    0.1 , 0.1 , 0.1 , 0.0   , 1.4 , 5.0 , 1.8 , 2.2  , 1.4  , 0.7  , 26.4  , 5.7  , 13.4 , 7.9  , 3.2  , 2.6  ,   0  ,  0   ,  0 ,  0,  // GA
                    0.1 , 0.7 , 0.4 , 0.2   , 3.3 , 12.4, 6.6 , 3.3  , 9.2  , 7.0  , 37.0  , 18.6 , 32.3 , 7.7  , 12.8 , 10.3 , 15.0 ,  0   ,  0 ,  0,  // GG 
                    0.0 , 0.4 , 0.3 , 0.2   , 9.0 , 6.1 , 5.2 , 6.6  , 11.0 , 2.6  , 69.2  , 81.0 , 18.6 , 10.5 , 55.5 , 54.5 , 0.7  , 39.6 ,  0 ,  0,  // UC
                    0.0 , 0.3 , 0.1 , 0.3   , 6.5 , 5.1 , 2.0 , 3.1  , 3.9  , 2.5  , 3.6   , 15.0 , 8.2  , 4.4  , 31.6 , 58.3 , 1.3  , 7.7  , 50.4, 0 }; //UU         
	
	// fill in the upper triangle of the matrix:
	for(unsigned int row = 1; row < size_; row++) {
		for(unsigned int col = 0; col <= row; col++) {
			int index = row * size_ + col;
			int index_twin = index - ( (size_-1)*row - (size_-1)*col );
			x[index_twin] = x[index];	
		}
	}
		
	// sum of rows = sum of columns
	for(unsigned int col = 0; col < size_; col++) {
		int e_col = a->charToInt(rrow[col]);
		double sum = 0;
		for(unsigned int row = 0; row < size_; row++) {
			sum += x[row*size_ + col];
			int e_row = a->charToInt(rrow[row]);
			exchangeability_(e_row,e_col) = x[row*size_ + col]; 
			exchangeability_(e_col,e_row) = x[row*size_ + col];
		}
		int index = col * (size_+1);
		x[index] = -1 * sum;	
		exchangeability_(e_col,e_col) = -1 *sum;
	}
	
	//cout << exchangeability_ << endl;
	for(unsigned int col = 0; col < size_; col++) {
		std::cout << "\t" << a->intToChar(col);	
	}
	std::cout << std::endl;
	
	for(unsigned int row = 0; row < size_; row++) {
		std::cout << a->intToChar(row);	
		for(unsigned int col = 0; col < size_; col++) {
	 		std::cout << "\t" << exchangeability_(row,col);
		}
		std::cout << std::endl;
	}
 	
}

void EukBasePairGapModel::setFreq(float * f) {
	
	LOG(lTRACE) << "EukBasePairGapModel::setFreq (pseudoCount) start"; 
	
   for(unsigned int i = 0; i < size_; i++) {
   	 freq_[bpa->charToInt(rrow[i])] = f[i];
   	 LOG(lTRACE) << i << " " << rrow[i] << " "  << bpa->charToInt(rrow[i]) << " " << f[i] << " " <<  freq_[bpa->charToInt(rrow[i])];
   }
	LOG(lTRACE) << "EukBasePairGapModel::setFreq (pseudoCount) end";
	
}

EukBasePairGapModel::~EukBasePairGapModel() {

	LOG(lTRACE2) << "EukBasePairGapModel destructor start"; 
	if(bpa != NULL)
		delete bpa;	
	LOG(lTRACE2) << "EukBasePairGapModel destructor end"; 
}




}
