#include <memory.h>

#include "PairedProSSUrRNASubstitutionModel.h"
#include "Log.h"
#include "BasePairAlphabet.h"
#include "ProBasePairModel.h"

using namespace std;

namespace ptr
{


bool PairedProSSUrRNASubstitutionModel::canHandleGaps() {
	return false;	
}

PairedProSSUrRNASubstitutionModel::PairedProSSUrRNASubstitutionModel()
{
	LOG(lTRACE)   << "PairedProSSUrRNA generic constructor start";
	this->size = 16;

	row["AA"] = 6; rrow[6] = "AA";
	row["AC"] = 7; rrow[7] = "AC";
	row["AG"] = 8; rrow[8] = "AG";
	row["AT"] = 0; rrow[0] = "AT";
	row["AU"] = 0; 
	row["CA"] = 9;  rrow[9] = "CA";	
	row["CC"] = 10; rrow[10] = "CC";
	row["CG"] = 5;  rrow[5] = "CG";	
	row["CT"] = 11;  rrow[11] = "CT";
	row["CU"] = 11; 
	row["GA"] = 12; rrow[12] = "GA";	
	row["GC"] = 2; rrow[2] = "GC";
	row["GG"] = 13; rrow[13] = "GG";	
	row["GT"] = 1; rrow[1] = "GT";
	row["GU"] = 1; 
	row["TA"] = 3; rrow[3] = "TA";	
	row["TC"] = 14; rrow[14] = "TC";
	row["TG"] = 4; rrow[4] = "TG";	
	row["TT"] = 15; rrow[15] = "TT";
	row["UA"] = 3; 	
	row["UC"] = 14; 
	row["UG"] = 4; 	
	row["UU"] = 15; 
	
	BasePairAlphabet * bpa = new BasePairAlphabet();	
	bpm = new ProBasePairModel(bpa);
	
	LOG(lTRACE)   << "PairedProSSUrRNA generic constructor end";
}

PairedProSSUrRNASubstitutionModel::~PairedProSSUrRNASubstitutionModel() {
	LOG(lTRACE) << "PairedProSSUrRNA destructor start";
	if(bpm != NULL)
		delete bpm;
	LOG(lTRACE) << "PairedProSSUrRNA destructor end";
}

double PairedProSSUrRNASubstitutionModel::P(int from, int to, double t, double mu){ 

	return bpm->Pij_t(bpm->getAlphabet()->charToInt(rrow[from]), bpm->getAlphabet()->charToInt(rrow[to]), t*mu); 
		
}


void PairedProSSUrRNASubstitutionModel::init() {
	LOG(lTRACE)  << "PairedProSSUrRNA init start";
	
	bpm->update();
	
	// test auf reversibilty  pi_i * Pij = pi_j * Pji
	/*for(int row = 0; row < size; row++) {
		for(int col = 0; col < size; col++) {
			double x = bpm->Pij_t(bpm->getAlphabet()->charToInt(rrow[row]), bpm->getAlphabet()->charToInt(rrow[col]), 0.3);
			double y = bpm->Pij_t(bpm->getAlphabet()->charToInt(rrow[col]), bpm->getAlphabet()->charToInt(rrow[row]), 0.3);
			LOG(lTRACE) << x << " "<< y << " " << freq[row] << " " << freq[col] << " " <<x * freq[row] - y * freq[col];
		}		
	}*/
	 		
	LOG(lTRACE)  << "PairedProSSUrRNA init end";
}

void PairedProSSUrRNASubstitutionModel::setFreq(float *f) {
	LOG(lTRACE)  << "PairedProSSUrRNA setFreq start";
	freq = f;	
	bpm->setFreq(f);
	LOG(lTRACE)  << "PairedProSSUrRNA setFreq end";
}




}
