#!/usr/bin/perl



package utils;



use strict;
use warnings;
use Data::Dumper;






sub getTemporaryDirectory {

	my ($tmp) = @_;
	my $range = 8000000000;
	my $newTmpRand = $tmp."tmpDir_"; ## if changing this name also change it in cleanTmp()
	my $random_number = int(rand($range));
	$newTmpRand .= $random_number."/";
	if(!-d $newTmpRand){ `mkdir $newTmpRand`; }
	else{
		while(-d $newTmpRand){
			$random_number = int(rand($range));
			$newTmpRand = $tmp."tmpDir_".$random_number."/";
		}
		`mkdir $newTmpRand`;
	}
	return($newTmpRand);
}



sub shuffleAlignment {

	my ($infoHash) = @_;
	
	print STDOUT "\#\# Shuffle alignment\n";
	
	my $ali2scan = $$infoHash{"ali2scan"};
	my $outDir = $$infoHash{"uniqueOutDir"};
	my $shuffleDir = $$infoHash{"shuffleDir"};
	my $multiperm = $$infoHash{"multiperm"};
	my $stk2aln = $$infoHash{"stk2alnTool"};
	my $shuffNum = $$infoHash{"shuffNum"};
	my $tmp = $$infoHash{"tmp"};
	my $tmpDir = getTemporaryDirectory($tmp);
	if(!-d $outDir.$shuffleDir){ `mkdir $outDir$shuffleDir`; }
	## unzip tmp alignment
	`cp $ali2scan $tmpDir`;
	my @pathArr = split(/\//,$ali2scan);
	my $zippAli2ScanName = pop(@pathArr);
	if($tmpDir.$zippAli2ScanName =~ /\.gz$/){ `gzip -d $tmpDir$zippAli2ScanName`; }
	$zippAli2ScanName =~ s/\.gz//g;
	my $clustalAli = $zippAli2ScanName;
	## re-format from STOCKHOLM to CLUSTAL
	if($zippAli2ScanName =~ /sto$/){ $clustalAli =~ s/sto/aln/g; }
	elsif($zippAli2ScanName =~ /stk$/){ $clustalAli =~ s/stk/aln/g; }
	else{ print "Alignment has not correct format\n\n"; }
	## convert STOCKHOLM to CLUSTAL W
	`$stk2aln $tmpDir$zippAli2ScanName $tmpDir$clustalAli`;
	## run multiperm
	chdir $tmpDir;
	
	`$multiperm -w -n $shuffNum $tmpDir$clustalAli`;
	opendir(TM, $tmpDir) or die "\nCan't open $tmpDir in utils\n\n";
	my @tmpArr = readdir(TM);
	close(TM);
	my $all = "";
	foreach my $tm(@tmpArr){
		if($tm =~ /^perm/){
			$all = $tm;
			$all =~ s/perm\_\d+\_/perm\_all\_/g;
			`cat $tmpDir$tm >> $all`; 
			
		}
	}
	`gzip -9 $all`;
	`cp $tmpDir$all".gz" $outDir$shuffleDir`;
	chdir $$infoHash{"rootPath"};
	`rm -rf $tmpDir`;
}




sub cleanTmp {
	
	my $tmpDir = shift;
	$tmpDir .= "tmpDir_*";
	`rm -rf $tmpDir`;
}




sub changeDirectoryName {
	
	my ($defFi, $uniqueOutDir, $modCleanRefseqRfamAli, $fam) = @_;
	my $newDefFi = $defFi.".txt";
	open(DE, "<$defFi") or die "Can't open $defFi\n\n";
	open(NDE, ">$newDefFi") or die "Can't open $newDefFi\n\n";
	
	while(<DE>){
		chomp($_);
		if($_ =~ /^(DATA_SOURCE[\s\t]+[\*\s\t]+)\/.+/){
			my $newLine = $1.$uniqueOutDir.$fam.$modCleanRefseqRfamAli;
			print NDE $newLine."\n";
		}
		else{ print NDE $_."\n"; }
	}
	close(DE);
	close(NDE);
	`rm -f $defFi`;
	`mv $newDefFi $defFi`;
}





sub changeNodeLines {
	
	my ($fred) = @_;
	my @arr = ();
	my $firstndx = 0;
	my $lastndx = 0;
	my $outcount = 0;
	my %newlinehash;
	my %nopairhash;
	my $nopairString = "NO_PAIRING";
	my $nopairinglinecount = -1;
	my $midsrc = 0;
	my $middst = 0;
	my $mustpairlinecount = 0;
	my $mustline = 0;
	
	## read definition file MUST PAIR lines
	open(FR, "< $fred") or die "\nCan't open $fred\n\n";
	while(<FR>){
		chomp($_);
		if($_ =~ /^PAIRS[\s\t]+(\d+)[\s\t]+(\d+)[\s\t]+MUST/){
			my $bp1 = $1;
			my $bp2 = $2;
			my $sr1 = -1;
			my $ds1 = -1;
			if($bp1 < $bp2){ $sr1 = $bp1 ; $ds1 = $bp2; }
			else{ $sr1 = $bp2 ; $ds1 = $bp1; }
			push(@arr, $sr1);
			push(@arr, $ds1);
		}
	}
	close(FR);

	## open def file again, change conds (last column) of each NODE that has a pairing partner
	my $lineCount = 0;
	open(PE, "<$fred") or die "\nCan't open $fred\n\n";
	while(<PE>){
		$lineCount++;
		chomp($_);
		if($_ =~ /^NODE[\s\t]+(\d+)/){
			my $headline = "";
			my $newpair = "";
			$lastndx = $1;
			for(my $x = 0; $x <= scalar @arr - 2; $x += 2){
				my $sr = "";
				my $ds = "";
				if($arr[$x+1] > $arr[$x]){ $ds = $arr[$x+1]; $sr = $arr[$x]; }
				else{ $ds = $arr[$x]; $sr = $arr[$x+1]; }
				
				if($_ =~ /^(NODE[\s\t]+$ds[\s\t]+\d+[\s\t]+\d+[\s\t]+)([\d\-\,]+)/){
					$headline = $1;
					my $conds = $2;
					
					if($conds eq "-"){ $newpair = $sr; }
					else{
						my $flag = "T";
						if($conds =~ /,/g){
							my @pairs = split(/,/, $conds);
							foreach my $p(@pairs){
								if($p == $sr){ $flag = "F"; }
							}
							if($flag eq "T"){ $newpair = $conds.",".$sr; }
							else{ $newpair = $conds; }
						}
						else{
							if($conds != $arr[$x]){ $newpair = $conds.",".$sr; }
							else{ $newpair = $conds; }
						}
					}
				}
				if($_ =~ /^NODE[\s\t]+(\d+)[\s\t]+1[\s\t]+0[\s\t]+[\d\,\-]+/){
					$middst = $1;
					$midsrc = $middst - 1;
				}
			}
			if($newpair ne ""){
				$newlinehash{$lineCount} = $headline.$newpair;
				$headline = "";
				$newpair = "";
			}
			else{
				$newlinehash{$lineCount} = $_;
			}
		}
		elsif($_ =~ /^NO_PAIRING/){
			$nopairinglinecount = $lineCount;
		}
		elsif($_ =~ /^PAIRS/){
			$mustline = $lineCount;
		}
		else{ $newlinehash{$lineCount} = $_; }
	}
	close(PE);
	
	
	## fill a hash with all NODE ids as keys that have a pairing partner
	## use this later for the NO_PAIRING line
	foreach my $ln(keys %newlinehash){
		my $lin = $newlinehash{$ln};
		if($lin =~ /^NODE/){
			my @arr = split(/[\s\t]+/, $lin);
			my $src = $arr[1];
			my $dst = $arr[4];
			
			if($dst ne "-"){
				$nopairhash{$src} = 1;
				my @condarr = split(/,/, $dst);
				foreach my $con(@condarr){
					$nopairhash{$con} = 1;
				}
			}
		}
	}

	## create MUST PAIR strings
	my $must1 = "PAIRS\t$firstndx\t$lastndx\tMUST";
	my $must2 = "PAIRS\t$midsrc\t$middst\tMUST";
	
	for(my $q = 0; $q <= $lastndx; $q++){
		if(! exists($nopairhash{$q})){ $nopairString .= "\t$q"; }
	}
	if($nopairinglinecount > -1){
		$newlinehash{$nopairinglinecount} = $nopairString;
	}
	else{
		$newlinehash{$mustline+1} = "";
		$newlinehash{$mustline+2} = $nopairString;
	}
	$newlinehash{($mustline-1)} = $must1;
	$newlinehash{$mustline} = $must2;
	
	#print output (a new file)
	my $out = $fred.".new";
	open(OT, ">$out") or die "\nCan't open $out\n\n";
	foreach my $kf(sort {$a<=>$b} keys %newlinehash){
		print OT $newlinehash{$kf}."\n";
	}
	print OT "\n\n";
	close(OT);
	
	## delete old file
	`rm -f $fred`;
	## mv new file to old name
	`mv $out $fred`;
}


1;
