#!/usr/bin/perl -w


package addAdditionalInfos;



use strict;
use warnings;
use Data::Dumper;






sub addInfos {
	
	my ($moHashRef, $class) = @_;
	## add some more infos to moHashRef
	my $moRep = getPdbMotifRepresentation($moHashRef);
	$$moHashRef{"moRep"} = $moRep;
	my $mutualInf = -1;
	my $dobra = $$moHashRef{"dotBracket"};
	#if($dobra !~ /[\<\>3]+/g){
	#	my $mofi = "class".$class;
	#	($mutualInf) = treeMI::getMutualInformation($moHashRef, $mofi);
	#}
	#print "MI: ".$mutualInf."\n\n";
	$$moHashRef{"mutualInf"} = $mutualInf;
	return($moHashRef);
}






sub getPdbMotifRepresentation {
	
	my $moHashRefi = shift;
	my $moRep = "";
	my $mo1Chain = $$moHashRefi{"chainInner1"};
	my $mo2Chain = $$moHashRefi{"chainInner2"};
	my $mo1StartSeqRes = $$moHashRefi{"posOuter1"};
	my $mo2StartSeqRes = $$moHashRefi{"posInner2"};
	my $intactHashRef = $$moHashRefi{"interactHash"};
	my $mo1StartPdbRes = $$intactHashRef{"base1PDBres"};
	my $mo2StartPdbRes = -1;
	my $baseNumber = -1;
	foreach my $base(keys %$intactHashRef){
		next unless($base =~ /base\d+SeqPos/);
		my $seqPos = $$intactHashRef{$base};
		if($seqPos == $mo2StartSeqRes){ $baseNumber = $base; last; }
	}
	$baseNumber =~ s/base//;
	$baseNumber =~ s/SeqPos//;
	$mo2StartPdbRes = $$intactHashRef{"base".$baseNumber."PDBres"};
	my $pumos = $$moHashRefi{"motifSeqs"};
	my ($pumo1, $pumo2) = split(/\&/, $pumos);
	my $l1 = length($pumo1);
	my $l2 = length($pumo2);
	$moRep = "<".$mo1Chain.":".$mo1StartPdbRes.":".$l1.",".$mo2Chain.":".$mo2StartPdbRes.":".$l2.">";
	return($moRep);
}


1;
