#!/usr/bin/perl


package filter;


use FindBin;
use lib "$FindBin::Bin/metaRNAmodules_mapping/";
use getRfamSeqInfo;
use align2cleanedRfam;
use clustalW;
use strict;
use warnings;
use Data::Dumper;




## Package to return for a given FR3D instance (PuMo) the mapping positions to PDB/Rfam
## Input: putative motif instance (format:: Instance: 3DKN F   11 F   25 / F   15 F   23)
## written: 09/03/2012 - corinna




sub filterMotifs {
	
	my ($moHashRef, $infoHash, $strucTabRef) = @_;
	
	####################
	## print information
	print STDOUT "\#\# Filter putative modules\n";
	
	my $fredDir = $$infoHash{"fr3dpath"};
	my $classFiZip = $$infoHash{"tmpClassFile"};
	my $mo1Chain = "";
	my $mo2Chain = "";
	my $intHashRef;
	my $pdbResOuter1 = 0;
	my $pdbResOuter2 = 0;
	my $pdbRfamChain = "";
	my $pdbResStart = 0;
	my $pdbResStop = 0;
	my $pdbEmblStart = 0;
	my $pdbEmblStop = 0;
	my $pdbEmblStrand = "";
	my $rfamEmblStart = 0;
	my $rfamEmblStop = 0;
	my $rfamEmblStrand = "";
	my $ungapSeq = "";
	my $ungapSeqLen = 0;
	my $mo1StopPdbRes = 0;
	my $mo2StartPdbRes = 0;
	
	$mo1Chain = $$moHashRef{"chainOuter1"};
	$mo1Chain =~ s/[\s\t]//g;
	$mo2Chain = $$moHashRef{"chainOuter2"};
	$mo2Chain =~ s/[\s\t]//g;
	$intHashRef = $$moHashRef{"interactHash"};
	$pdbResOuter1 = $$intHashRef{"base1PDBres"};
	$pdbResOuter1 =~ s/[\s\t]//g;
	$pdbResOuter2 = $$intHashRef{"base2PDBres"};
	$pdbResOuter2 =~ s/[\s\t]//g;
	$pdbRfamChain = $$strucTabRef{"pdbRfamChain"};
	$pdbResStart = $$strucTabRef{"pdbResStart"};
	$pdbResStop = $$strucTabRef{"pdbResStop"};
	$pdbEmblStart = $$strucTabRef{"pdbEmblSeqPosStart"};
	$pdbEmblStop = $$strucTabRef{"pdbEmblSeqPosStop"};
	$pdbEmblStrand = $$strucTabRef{"pdbEmblStrand"};
	my $fam = $$strucTabRef{"fam"};
	my $rfamFullGappedDir = $$infoHash{"rfamFullGappedDir"};
	my $tmpDir = $$infoHash{"instTmpDir"};
	my $outDir = $$infoHash{"outDir"};
	my $rfamSeqInfoHashRef = getRfamSeqInfo::getRfamEmblInfo($strucTabRef, $classFiZip, $rfamFullGappedDir, $tmpDir);
	
	$rfamEmblStart = $$rfamSeqInfoHashRef{"rfamEmblSeqPosStart"};
	$rfamEmblStop = $$rfamSeqInfoHashRef{"rfamEmblSeqPosStop"};
	$rfamEmblStrand = $$rfamSeqInfoHashRef{"rfamEmblStrand"};
	$ungapSeq = $$rfamSeqInfoHashRef{"fullUngapSeq"};
	
	$ungapSeqLen = length($ungapSeq);
	
	##################     F I L T E R  ##############
	## 4. filter: do rfam and pdb seq map on same region?			
	if(($rfamEmblStart <= $pdbEmblStart) && ($rfamEmblStop >= $pdbEmblStop)){
				
		## 5. filter: map pdb and rfam seq on the same strand on EMBL
		if($rfamEmblStrand eq $pdbEmblStrand){
				
			## match pdb on ungapped Rfam seq (optional)
			######($pdbRfamStart, $pdbRfamStop) = mapPdb2Rfam($rfamEmblStart, $rfamEmblStop, $pdbEmblStart, $pdbEmblStop, $ungapSeqLen);
			
			
			$$strucTabRef{"rfamEmblSeqPosStart"} = $rfamEmblStart;
			$$strucTabRef{"rfamEmblSeqPosStop"} = $rfamEmblStop;
			$$strucTabRef{"rfamEmblStrand"} = $rfamEmblStrand;
			$$strucTabRef{"fullUngapSeq"} = $ungapSeq;
				
			my $newAliPath = align2cleanedRfam::alignFullSeq2CleanedSeedAli($fam, $infoHash, $strucTabRef);
			unless($newAliPath eq ""){
				$$infoHash{"fullSeedAliPath"} = $newAliPath;
				
				clustalW::prepareClustalW($strucTabRef, $moHashRef, $outDir, $infoHash);
			}
		}
		else{
			print "Not the same strand $rfamEmblStrand eq $pdbEmblStrand\n";
		}
	}
	else{
		print " Not the same region ($rfamEmblStart <= $pdbEmblStart ) && ($rfamEmblStop >= $pdbEmblStop )\n";
	}
}

1;
