#!/usr/bin/perl


package getGappedPositions;



use strict;
use warnings;
use Data::Dumper;




sub getGappedPositions {

	my ($ug11, $ug12, $ug21, $ug22, $gapSeq) = @_;
	my $gapSeqHashRef = getGappedPosHash($gapSeq);
	my $g11 = 0;
	my $g12 = 0;
	my $g21 = 0;
	my $g22 = 0;
	$g11 = $$gapSeqHashRef{$ug11};
	$g12 = $$gapSeqHashRef{$ug12};
	$g21 = $$gapSeqHashRef{$ug21};
	$g22 = $$gapSeqHashRef{$ug22};
	return($g11, $g12, $g21, $g22);
}



sub getGappedPos {

	my ($pos, $gapSeq) = @_;
	my $gapSeqHashRef = getGappedPosHash($gapSeq);
	my $gpos = 0;
	$gpos = $$gapSeqHashRef{$pos};
	return($gpos);
}



sub getGappedHash {

	my ($posHashRef, $gapSeq) = @_;
	my $gapSeqHashRef = getGappedPosHash($gapSeq);
	my %gposHash;
	foreach my $po(keys %$posHashRef){
		my $gpos = $$gapSeqHashRef{$po};
		$gposHash{$gpos} = $$posHashRef{$po};
	}
	return(\%gposHash);
}



sub getGappedSeq {

	my ($singleLineAliHashRef) = @_;
	my ($gapSeqID) = grep {/^full/} keys %$singleLineAliHashRef;
	my $gapSeq = uc($$singleLineAliHashRef{$gapSeqID});
	return($gapSeq);
}



sub getSingleLineAli {

	my ($fullSeedAliPath) = @_;
	my @nameArr = ();
	my @headArr = ();
	my %seqHash;
	my $seqNum = 0;
	my $sscons = "";
	my $seqcons = "";
	my $count = 0;
	my $seqCount = 0;
	
	open(AL, $fullSeedAliPath) or die "Can't open $fullSeedAliPath in getGappedPosition\n\n";
	while(<AL>){
		next unless($_ !~ /^\# STOCKHOLM 1\.0/);
		next unless($_ !~ /^$/);
		chomp($_);
		if(($_ =~ /^\#/) && ($_ !~ /\#=GC[\s\t]+SS\_cons/) && ($_ !~ /\#=GC[\s\t]+RF/)){
			push(@headArr, $_);
			if($_ =~ /\#=GF[\s\t]+SQ[\s\t]+(\d+)/){ $seqNum = $1; }
		}		
		elsif(($_ =~ /\#=GC[\s\t]+SS\_cons/) || ($_ =~ /\#=GC[\s\t]+RF/)){
			my ($name1, $name2, $seqi) = split(/[\s\t]+/,$_);
			if(exists($seqHash{$name1." ".$name2})){ $seqHash{$name1." ".$name2} .= $seqi; }
			else{ $seqHash{$name1." ".$name2} = $seqi; }
			if($count < $seqNum+3){
				push(@nameArr, $name1." ".$name2);
				$count++;
			}
		}
		elsif($_ =~ /^\/\//){
			##do nothing ;)
		}
		else{
			my ($name, $seq) = split(/[\s\t]+/,$_);
			if($count < $seqNum+3){
				push(@nameArr, $name);
				$count++;
				$seqCount++;
			}
			if(exists($seqHash{$name})){ $seqHash{$name} .= $seq; }
			else{ $seqHash{$name} = $seq; }
		}
	}
	close(AL);
	return(\%seqHash, \@nameArr, \@headArr, $seqCount);
}






sub getGappedPosHash {

	my $gapSeq = shift;
	my $un = "";
	($un = $gapSeq) =~ s/[\-\_\.\;\,]//g;
	my $ungaplen = length($un);
	my $lenGap = length($gapSeq);
	my %hash;
	my $dotcount = 0;
	my $ungapIndex = 1;
	
	for(my $x =1; $x <= length($gapSeq) ; $x++){
		
		my $letter = substr($gapSeq,$x-1,1);
		if(($letter eq ".") || ($letter eq "-") || ($letter eq "_") || ($letter eq ",") || ($letter eq ";")){
			$dotcount++;
		}
		else{
			$hash{$ungapIndex} = $dotcount+$ungapIndex;
			$ungapIndex++;
		}
	}
	return(\%hash);
}


1;
