#!/usr/bin/perl


package newClass;


use FindBin;
use lib "$FindBin::Bin/metaRNAmodules_mapping/";
use lib "$FindBin::Bin/metaRNAmodules_model/";
use addAdditionalInfos;
use getGappedPositions;
use prepare_stockholm_file;
use createTrainingAndTestData;
use createData;
use printFiles;
use createModel;
use strict;
use warnings;
use Data::Dumper;




sub goAhead {

	my ($moHashRef, $strucTabHashRef, $infoHash) = @_;
	####################
	## print information
	print STDOUT "\#\# Mapping done; Start preparing data\n";
	
	my $outDir = $$infoHash{"outdir"};
	my $testFiName = $$infoHash{"modCleanRfamAli"};
	my $fullSeedAliPath = $$infoHash{"fullSeedAliPath"};
	my $tmp = $$infoHash{"instTmpDir"};
	my $modAliName = $$infoHash{"modAliName"};
	my $uniqueModuleNameSuffix = $$infoHash{"uniqueModuleNameSuffix"};
	my $ug11 = $$moHashRef{"ungapSeedAliPumo1RfamStart"};
	my $ug12 = $$moHashRef{"ungapSeedAliPumo1RfamStop"};
	my $ug21 = $$moHashRef{"ungapSeedAliPumo2RfamStart"};
	my $ug22 = $$moHashRef{"ungapSeedAliPumo2RfamStop"};
	my $pdb = $$moHashRef{"pdb"};
	my $classa = $$moHashRef{"class"};
	my $dobr = $$moHashRef{"dotBracket"};
	my $fam = $$strucTabHashRef{"fam"};
	my $class = $$moHashRef{"class"};
	
	## add PdbMotifRepresentation and Mutual information
	#$moHashRef = addAdditionalInfos::addInfos($moHashRef, $classa);
	
	my ($singleLineAliHashRef, $seqNameArrRef, $headArrRef, $seqNum) = getGappedPositions::getSingleLineAli($fullSeedAliPath);
	
	my $gapSeq = getGappedPositions::getGappedSeq($singleLineAliHashRef);
	#print "$dobr, $ug11,$ug12,$ug21,$ug22\n\n";
	my $pairedPosHashRef = getPairedUngappedPos($dobr, $ug11,$ug12,$ug21,$ug22);
	#print Dumper $pairedPosHashRef;
	my $pairedGappedHashRef = getGappedPositions::getGappedHash($pairedPosHashRef, $gapSeq);
	
	## get gapped positions before modifying the alignment
	my ($g11, $g12, $g21, $g22) = getGappedPositions::getGappedPositions($ug11, $ug12, $ug21, $ug22, $gapSeq);
	$$moHashRef{"gapSeedAliPumo1RfamStart_notModified"} = $g11;
	$$moHashRef{"gapSeedAliPumo1RfamStop_notModified"} = $g12;
	$$moHashRef{"gapSeedAliPumo2RfamStart_notModified"} = $g21;
	$$moHashRef{"gapSeedAliPumo2RfamStop_notModified"} = $g22;
	
	#######################################################################
	my $modifiedAlignmentHashRef = prepare_stockholm_file::prepareStockholm($singleLineAliHashRef, $gapSeq, $g11, $g12, $g21, $g22, $seqNum, $pairedGappedHashRef);
	
	
	my ($modGapSeqID) = grep  {/^full/} keys %$modifiedAlignmentHashRef;
	my $modGapSeq = $$modifiedAlignmentHashRef{$modGapSeqID};
	## get gapped positions after first modification of the alignment
	my ($mg11, $mg12, $mg21, $mg22) = getGappedPositions::getGappedPositions($ug11, $ug12, $ug21, $ug22, $modGapSeq);
	
	$$moHashRef{"gapSeedAliPumo1RfamStart"} = $mg11;
	$$moHashRef{"gapSeedAliPumo1RfamStop"} = $mg12;
	$$moHashRef{"gapSeedAliPumo2RfamStart"} = $mg21;
	$$moHashRef{"gapSeedAliPumo2RfamStop"} = $mg22;
	
	## print alignment after first modification step
	my $tmpModStkAliPath = printFiles::printModifiedAlignment($modifiedAlignmentHashRef, $seqNameArrRef, $headArrRef, $tmp, $fam, $modAliName);
	
	## print module file, create unique name and outDir
	my $uniqueOutDir = $outDir.$fam."_".$class."_".$pdb."_".$ug11."_".$ug12."_".$ug21."_".$ug22."/";
	my $uniqueModuleName = $fam."_".$class."_".$pdb."_".$ug11."_".$ug12."_".$ug21."_".$ug22;
	$$moHashRef{"uniqueModuleName"} = $uniqueModuleName;
	$$infoHash{"uniqueOutDir"} = $uniqueOutDir;
	if(!-d $uniqueOutDir){ `mkdir $uniqueOutDir`; }
	
	print "\#\# Unique output directory:\n$uniqueOutDir\n";
	my $motifFile = printFiles::printMoRep($moHashRef, $strucTabHashRef, $uniqueOutDir, $uniqueModuleNameSuffix);
	
	createData::modifyAli($tmpModStkAliPath, $fam, $uniqueOutDir, $moHashRef, $testFiName);
	
	createModel::createModel($moHashRef, $strucTabHashRef, $motifFile, $infoHash);
}




sub getPairedUngappedPos {

	my ($dobr,$ug11,$ug12,$ug21,$ug22) = @_;
	my %pairedPosHash;
	my $len1 = $ug12 - $ug11 + 1;
	my $len2 = $ug22 - $ug21 + 1;
	my $dob1 = substr($dobr, 0, $len1);
	my $dob2 = substr($dobr, ($len1+1) , $len2);
	my $tmpug11 = $ug11;
	for(my $c = 0; $c < length($dob1); $c++){
		my $brac = substr($dob1,$c,1);
		if($brac =~ /\.{1}/){
			$pairedPosHash{$tmpug11} = 0;
		}
		else{ $pairedPosHash{$tmpug11} = 1; }
		$tmpug11++;
	}
	my $tmpug21 = $ug21;
	for(my $cc = 0; $cc < length($dob2); $cc++){
		my $brac2 = substr($dob2,$cc,1);
		if($brac2 =~ /\.{1}/){
			$pairedPosHash{$tmpug21} = 0;
		}
		else{ $pairedPosHash{$tmpug21} = 1; }
		$tmpug21++;
	}
	return(\%pairedPosHash);
}

1;
